/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;

class PdfPages {
    private final ArrayList pages = new ArrayList();
    private final ArrayList parents = new ArrayList();
    private final int leafSize = 10;
    private final PdfWriter writer;
    private PdfIndirectReference topParent;

    PdfPages(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    void addPage(PdfDictionary pdfDictionary) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
            pdfDictionary.put(PdfName.PARENT, pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = this.writer.getCurrentPage();
            this.writer.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
            this.pages.add(pdfIndirectReference2);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    PdfIndirectReference addPageRef(PdfIndirectReference pdfIndirectReference) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            this.pages.add(pdfIndirectReference);
            return (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    PdfIndirectReference writePageTree() throws IOException {
        if (this.pages.isEmpty()) {
            throw new IOException("The document has no pages.");
        }
        int n = 1;
        ArrayList<PdfIndirectReference> arrayList = this.parents;
        ArrayList arrayList2 = this.pages;
        ArrayList<PdfIndirectReference> arrayList3 = new ArrayList<PdfIndirectReference>();
        while (true) {
            n *= this.leafSize;
            int n2 = this.leafSize;
            int n3 = arrayList2.size() % this.leafSize;
            if (n3 == 0) {
                n3 = this.leafSize;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n4;
                int n5 = n;
                if (i == arrayList.size() - 1) {
                    n4 = n3;
                    n5 = this.pages.size() % n;
                    if (n5 == 0) {
                        n5 = n;
                    }
                } else {
                    n4 = n2;
                }
                PdfDictionary pdfDictionary = new PdfDictionary(PdfName.PAGES);
                pdfDictionary.put(PdfName.COUNT, new PdfNumber(n5));
                PdfArray pdfArray = new PdfArray();
                ArrayList arrayList4 = pdfArray.getArrayList();
                arrayList4.addAll(arrayList2.subList(i * n2, i * n2 + n4));
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                if (arrayList.size() > 1) {
                    if (i % this.leafSize == 0) {
                        arrayList3.add(this.writer.getPdfIndirectReference());
                    }
                    pdfDictionary.put(PdfName.PARENT, (PdfIndirectReference)arrayList3.get(i / this.leafSize));
                } else {
                    pdfDictionary.put(PdfName.ITXT, new PdfString(Document.getRelease()));
                }
                this.writer.addToBody((PdfObject)pdfDictionary, (PdfIndirectReference)arrayList.get(i));
            }
            if (arrayList.size() == 1) {
                this.topParent = (PdfIndirectReference)arrayList.get(0);
                return this.topParent;
            }
            arrayList2 = arrayList;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
    }
}

