/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

class PdfPageLabels {
    private static final int DECIMAL_ARABIC_NUMERALS = 0;
    private static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    private final HashMap map = new LinkedHashMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    private void addPageLabel(int n, int n2, String string, int n3) {
        if (n < 1 || n3 < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (n2 >= 0 && n2 < numberingStyle.length) {
            pdfDictionary.put(PdfName.S, numberingStyle[n2]);
        }
        if (string != null) {
            pdfDictionary.put(PdfName.P, new PdfString(string, "UnicodeBig"));
        }
        if (n3 != 1) {
            pdfDictionary.put(PdfName.ST, new PdfNumber(n3));
        }
        this.map.put(new Integer(n - 1), pdfDictionary);
    }

    PdfDictionary getDictionary(PdfWriter pdfWriter) {
        try {
            return PdfNumberTree.writeTree(this.map, pdfWriter);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private static class PdfPageLabelFormat {
        private final int physicalPage;
        private final int numberStyle;
        private final String prefix;
        private final int logicalPage;

        private PdfPageLabelFormat(int n, int n2, String string, int n3) {
            this.physicalPage = n;
            this.numberStyle = n2;
            this.prefix = string;
            this.logicalPage = n3;
        }
    }
}

