/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfObject;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class PdfName
extends PdfObject
implements Comparable {
    public static final PdfName A = new PdfName("A");
    static final PdfName AA = new PdfName("AA");
    public static final PdfName ABSOLUTECOLORIMETRIC = new PdfName("AbsoluteColorimetric");
    static final PdfName AC = new PdfName("AC");
    static final PdfName ACROFORM = new PdfName("AcroForm");
    public static final PdfName ADBE_PKCS7_DETACHED = new PdfName("adbe.pkcs7.detached");
    static final PdfName ADBE_PKCS7_S4 = new PdfName("adbe.pkcs7.s4");
    static final PdfName ADBE_PKCS7_S5 = new PdfName("adbe.pkcs7.s5");
    static final PdfName ADBE_PKCS7_SHA1 = new PdfName("adbe.pkcs7.sha1");
    static final PdfName ADBE_X509_RSA_SHA1 = new PdfName("adbe.x509.rsa_sha1");
    public static final PdfName ADOBE_PPKLITE = new PdfName("Adobe.PPKLite");
    static final PdfName ADOBE_PPKMS = new PdfName("Adobe.PPKMS");
    static final PdfName AESV2 = new PdfName("AESV2");
    static final PdfName AIS = new PdfName("AIS");
    static final PdfName ALTERNATE = new PdfName("Alternate");
    static final PdfName ANNOT = new PdfName("Annot");
    static final PdfName ANNOTS = new PdfName("Annots");
    static final PdfName ANTIALIAS = new PdfName("AntiAlias");
    static final PdfName AP = new PdfName("AP");
    public static final PdfName APPDEFAULT = new PdfName("AppDefault");
    public static final PdfName ARTBOX = new PdfName("ArtBox");
    static final PdfName ASCENT = new PdfName("Ascent");
    static final PdfName AS = new PdfName("AS");
    static final PdfName AUTHEVENT = new PdfName("AuthEvent");
    public static final PdfName AUTHOR = new PdfName("Author");
    static final PdfName B = new PdfName("B");
    static final PdfName BASEENCODING = new PdfName("BaseEncoding");
    static final PdfName BASEFONT = new PdfName("BaseFont");
    public static final PdfName BASEVERSION = new PdfName("BaseVersion");
    static final PdfName BBOX = new PdfName("BBox");
    static final PdfName BC = new PdfName("BC");
    static final PdfName BG = new PdfName("BG");
    static final PdfName BIGFIVE = new PdfName("BigFive");
    public static final PdfName BITSPERCOMPONENT = new PdfName("BitsPerComponent");
    static final PdfName BLACKIS1 = new PdfName("BlackIs1");
    public static final PdfName BLEEDBOX = new PdfName("BleedBox");
    static final PdfName BLINDS = new PdfName("Blinds");
    public static final PdfName BM = new PdfName("BM");
    static final PdfName BORDER = new PdfName("Border");
    static final PdfName BOX = new PdfName("Box");
    static final PdfName BS = new PdfName("BS");
    static final PdfName BTN = new PdfName("Btn");
    static final PdfName BYTERANGE = new PdfName("ByteRange");
    static final PdfName C = new PdfName("C");
    static final PdfName C0 = new PdfName("C0");
    static final PdfName C1 = new PdfName("C1");
    public static final PdfName CA = new PdfName("CA");
    public static final PdfName ca = new PdfName("ca");
    public static final PdfName CALGRAY = new PdfName("CalGray");
    public static final PdfName CALRGB = new PdfName("CalRGB");
    static final PdfName CAPHEIGHT = new PdfName("CapHeight");
    static final PdfName CATALOG = new PdfName("Catalog");
    static final PdfName CATEGORY = new PdfName("Category");
    static final PdfName CCITTFAXDECODE = new PdfName("CCITTFaxDecode");
    public static final PdfName CENTERWINDOW = new PdfName("CenterWindow");
    static final PdfName CERT = new PdfName("Cert");
    static final PdfName CF = new PdfName("CF");
    static final PdfName CFM = new PdfName("CFM");
    static final PdfName CH = new PdfName("Ch");
    static final PdfName CIDFONTTYPE0 = new PdfName("CIDFontType0");
    static final PdfName CIDFONTTYPE2 = new PdfName("CIDFontType2");
    static final PdfName CIDSET = new PdfName("CIDSet");
    static final PdfName CIDSYSTEMINFO = new PdfName("CIDSystemInfo");
    static final PdfName CIDTOGIDMAP = new PdfName("CIDToGIDMap");
    static final PdfName CO = new PdfName("CO");
    public static final PdfName COLORS = new PdfName("Colors");
    public static final PdfName COLORSPACE = new PdfName("ColorSpace");
    static final PdfName COLLECTION = new PdfName("Collection");
    public static final PdfName COLLECTIONSCHEMA = new PdfName("CollectionSchema");
    public static final PdfName COLUMNS = new PdfName("Columns");
    static final PdfName CONTACTINFO = new PdfName("ContactInfo");
    public static final PdfName CONTENTS = new PdfName("Contents");
    static final PdfName COORDS = new PdfName("Coords");
    static final PdfName COUNT = new PdfName("Count");
    static final PdfName COURIER = new PdfName("Courier");
    static final PdfName COURIER_BOLD = new PdfName("Courier-Bold");
    static final PdfName COURIER_OBLIQUE = new PdfName("Courier-Oblique");
    static final PdfName COURIER_BOLDOBLIQUE = new PdfName("Courier-BoldOblique");
    public static final PdfName CREATIONDATE = new PdfName("CreationDate");
    public static final PdfName CREATOR = new PdfName("Creator");
    public static final PdfName CROPBOX = new PdfName("CropBox");
    static final PdfName CRYPT = new PdfName("Crypt");
    static final PdfName CS = new PdfName("CS");
    public static final PdfName D = new PdfName("D");
    static final PdfName DA = new PdfName("DA");
    static final PdfName DATA = new PdfName("Data");
    static final PdfName DCTDECODE = new PdfName("DCTDecode");
    static final PdfName DECODE = new PdfName("Decode");
    public static final PdfName DECODEPARMS = new PdfName("DecodeParms");
    static final PdfName DEFAULTCRYPTFILTER = new PdfName("DefaultCryptFilter");
    static final PdfName DEFAULTRGB = new PdfName("DefaultRGB");
    static final PdfName DESC = new PdfName("Desc");
    static final PdfName DESCENDANTFONTS = new PdfName("DescendantFonts");
    static final PdfName DESCENT = new PdfName("Descent");
    static final PdfName DEST = new PdfName("Dest");
    static final PdfName DESTOUTPUTPROFILE = new PdfName("DestOutputProfile");
    static final PdfName DESTS = new PdfName("Dests");
    public static final PdfName DEVICEGRAY = new PdfName("DeviceGray");
    public static final PdfName DEVICERGB = new PdfName("DeviceRGB");
    static final PdfName DEVICECMYK = new PdfName("DeviceCMYK");
    static final PdfName DI = new PdfName("Di");
    static final PdfName DIFFERENCES = new PdfName("Differences");
    static final PdfName DISSOLVE = new PdfName("Dissolve");
    public static final PdfName DIRECTION = new PdfName("Direction");
    public static final PdfName DISPLAYDOCTITLE = new PdfName("DisplayDocTitle");
    static final PdfName DM = new PdfName("Dm");
    static final PdfName DOCMDP = new PdfName("DocMDP");
    static final PdfName DOCOPEN = new PdfName("DocOpen");
    static final PdfName DOMAIN = new PdfName("Domain");
    static final PdfName DP = new PdfName("DP");
    static final PdfName DR = new PdfName("DR");
    static final PdfName DS = new PdfName("DS");
    static final PdfName DUR = new PdfName("Dur");
    public static final PdfName DUPLEX = new PdfName("Duplex");
    public static final PdfName DUPLEXFLIPSHORTEDGE = new PdfName("DuplexFlipShortEdge");
    public static final PdfName DUPLEXFLIPLONGEDGE = new PdfName("DuplexFlipLongEdge");
    static final PdfName DV = new PdfName("DV");
    static final PdfName DW = new PdfName("DW");
    public static final PdfName E = new PdfName("E");
    static final PdfName EF = new PdfName("EF");
    static final PdfName EFF = new PdfName("EFF");
    static final PdfName EFOPEN = new PdfName("EFOpen");
    static final PdfName EMBEDDEDFILE = new PdfName("EmbeddedFile");
    static final PdfName EMBEDDEDFILES = new PdfName("EmbeddedFiles");
    static final PdfName ENCODEDBYTEALIGN = new PdfName("EncodedByteAlign");
    static final PdfName ENCODING = new PdfName("Encoding");
    static final PdfName ENCRYPT = new PdfName("Encrypt");
    static final PdfName ENCRYPTMETADATA = new PdfName("EncryptMetadata");
    static final PdfName ENDOFBLOCK = new PdfName("EndOfBlock");
    static final PdfName ENDOFLINE = new PdfName("EndOfLine");
    static final PdfName EXTEND = new PdfName("Extend");
    public static final PdfName EXTENSIONS = new PdfName("Extensions");
    public static final PdfName EXTENSIONLEVEL = new PdfName("ExtensionLevel");
    public static final PdfName EXTGSTATE = new PdfName("ExtGState");
    static final PdfName EXPORT = new PdfName("Export");
    static final PdfName EXPORTSTATE = new PdfName("ExportState");
    static final PdfName EVENT = new PdfName("Event");
    static final PdfName F = new PdfName("F");
    static final PdfName FB = new PdfName("FB");
    static final PdfName FDF = new PdfName("FDF");
    static final PdfName FF = new PdfName("Ff");
    static final PdfName FIELDS = new PdfName("Fields");
    static final PdfName FILEATTACHMENT = new PdfName("FileAttachment");
    static final PdfName FILESPEC = new PdfName("Filespec");
    static final PdfName FILTER = new PdfName("Filter");
    static final PdfName FIRST = new PdfName("First");
    static final PdfName FIRSTCHAR = new PdfName("FirstChar");
    static final PdfName FIRSTPAGE = new PdfName("FirstPage");
    public static final PdfName FITWINDOW = new PdfName("FitWindow");
    static final PdfName FLAGS = new PdfName("Flags");
    static final PdfName FLATEDECODE = new PdfName("FlateDecode");
    public static final PdfName FONT = new PdfName("Font");
    static final PdfName FONTBBOX = new PdfName("FontBBox");
    static final PdfName FONTDESCRIPTOR = new PdfName("FontDescriptor");
    static final PdfName FONTFILE = new PdfName("FontFile");
    static final PdfName FONTFILE2 = new PdfName("FontFile2");
    static final PdfName FONTFILE3 = new PdfName("FontFile3");
    static final PdfName FONTNAME = new PdfName("FontName");
    static final PdfName FORM = new PdfName("Form");
    static final PdfName FORMTYPE = new PdfName("FormType");
    static final PdfName FREETEXT = new PdfName("FreeText");
    static final PdfName FRM = new PdfName("FRM");
    static final PdfName FS = new PdfName("FS");
    static final PdfName FT = new PdfName("FT");
    public static final PdfName FULLSCREEN = new PdfName("FullScreen");
    static final PdfName FUNCTION = new PdfName("Function");
    static final PdfName FUNCTIONTYPE = new PdfName("FunctionType");
    public static final PdfName GAMMA = new PdfName("Gamma");
    static final PdfName GBK = new PdfName("GBK");
    static final PdfName GLITTER = new PdfName("Glitter");
    static final PdfName GOTO = new PdfName("GoTo");
    static final PdfName GOTOE = new PdfName("GoToE");
    static final PdfName GOTOR = new PdfName("GoToR");
    static final PdfName GROUP = new PdfName("Group");
    static final PdfName GTS_PDFA1 = new PdfName("GTS_PDFA1");
    public static final PdfName GTS_PDFX = new PdfName("GTS_PDFX");
    public static final PdfName GTS_PDFXVERSION = new PdfName("GTS_PDFXVersion");
    static final PdfName H = new PdfName("H");
    static final PdfName HEIGHT = new PdfName("Height");
    static final PdfName HELV = new PdfName("Helv");
    static final PdfName HELVETICA = new PdfName("Helvetica");
    static final PdfName HELVETICA_BOLD = new PdfName("Helvetica-Bold");
    static final PdfName HELVETICA_OBLIQUE = new PdfName("Helvetica-Oblique");
    static final PdfName HELVETICA_BOLDOBLIQUE = new PdfName("Helvetica-BoldOblique");
    static final PdfName HIDE = new PdfName("Hide");
    public static final PdfName HIDEMENUBAR = new PdfName("HideMenubar");
    public static final PdfName HIDETOOLBAR = new PdfName("HideToolbar");
    public static final PdfName HIDEWINDOWUI = new PdfName("HideWindowUI");
    static final PdfName I = new PdfName("I");
    static final PdfName ICCBASED = new PdfName("ICCBased");
    static final PdfName ID = new PdfName("ID");
    static final PdfName IDENTITY = new PdfName("Identity");
    static final PdfName IF = new PdfName("IF");
    static final PdfName IMAGE = new PdfName("Image");
    static final PdfName IMAGEMASK = new PdfName("ImageMask");
    static final PdfName INDEX = new PdfName("Index");
    public static final PdfName INDEXED = new PdfName("Indexed");
    public static final PdfName INFO = new PdfName("Info");
    public static final PdfName INTENT = new PdfName("Intent");
    static final PdfName INTERPOLATE = new PdfName("Interpolate");
    static final PdfName ISMAP = new PdfName("IsMap");
    static final PdfName ITALICANGLE = new PdfName("ItalicAngle");
    static final PdfName ITXT = new PdfName("ITXT");
    static final PdfName IX = new PdfName("IX");
    static final PdfName JAVASCRIPT = new PdfName("JavaScript");
    static final PdfName JBIG2DECODE = new PdfName("JBIG2Decode");
    static final PdfName JBIG2GLOBALS = new PdfName("JBIG2Globals");
    static final PdfName JPXDECODE = new PdfName("JPXDecode");
    static final PdfName JS = new PdfName("JS");
    static final PdfName K = new PdfName("K");
    public static final PdfName KEYWORDS = new PdfName("Keywords");
    static final PdfName KIDS = new PdfName("Kids");
    public static final PdfName L2R = new PdfName("L2R");
    static final PdfName LAST = new PdfName("Last");
    static final PdfName LASTCHAR = new PdfName("LastChar");
    static final PdfName LASTPAGE = new PdfName("LastPage");
    static final PdfName LAUNCH = new PdfName("Launch");
    static final PdfName LENGTH = new PdfName("Length");
    static final PdfName LIMITS = new PdfName("Limits");
    static final PdfName LINK = new PdfName("Link");
    static final PdfName LISTMODE = new PdfName("ListMode");
    static final PdfName LOCATION = new PdfName("Location");
    static final PdfName LOCK = new PdfName("Lock");
    static final PdfName LOCKED = new PdfName("Locked");
    static final PdfName M = new PdfName("M");
    public static final PdfName MATRIX = new PdfName("Matrix");
    static final PdfName MAC_ROMAN_ENCODING = new PdfName("MacRomanEncoding");
    static final PdfName MARKED = new PdfName("Marked");
    static final PdfName MARKINFO = new PdfName("MarkInfo");
    public static final PdfName MASK = new PdfName("Mask");
    static final PdfName MAXLEN = new PdfName("MaxLen");
    public static final PdfName MEDIABOX = new PdfName("MediaBox");
    static final PdfName METADATA = new PdfName("Metadata");
    static final PdfName MK = new PdfName("MK");
    static final PdfName MMTYPE1 = new PdfName("MMType1");
    public static final PdfName MODDATE = new PdfName("ModDate");
    public static final PdfName N = new PdfName("N");
    static final PdfName NAME = new PdfName("Name");
    static final PdfName NAMED = new PdfName("Named");
    static final PdfName NAMES = new PdfName("Names");
    static final PdfName NEEDAPPEARANCES = new PdfName("NeedAppearances");
    static final PdfName NEWWINDOW = new PdfName("NewWindow");
    static final PdfName NEXT = new PdfName("Next");
    static final PdfName NEXTPAGE = new PdfName("NextPage");
    static final PdfName NM = new PdfName("NM");
    public static final PdfName NONE = new PdfName("None");
    public static final PdfName NONFULLSCREENPAGEMODE = new PdfName("NonFullScreenPageMode");
    public static final PdfName NUMCOPIES = new PdfName("NumCopies");
    static final PdfName NUMS = new PdfName("Nums");
    public static final PdfName O = new PdfName("O");
    static final PdfName OBJSTM = new PdfName("ObjStm");
    static final PdfName OC = new PdfName("OC");
    static final PdfName OCGS = new PdfName("OCGs");
    static final PdfName OCMD = new PdfName("OCMD");
    static final PdfName OCPROPERTIES = new PdfName("OCProperties");
    static final PdfName Off = new PdfName("Off");
    static final PdfName OFF = new PdfName("OFF");
    static final PdfName ON = new PdfName("ON");
    public static final PdfName ONECOLUMN = new PdfName("OneColumn");
    static final PdfName OPENACTION = new PdfName("OpenAction");
    static final PdfName OP = new PdfName("OP");
    static final PdfName op = new PdfName("op");
    static final PdfName OPM = new PdfName("OPM");
    static final PdfName OPT = new PdfName("Opt");
    static final PdfName ORDER = new PdfName("Order");
    static final PdfName ORDERING = new PdfName("Ordering");
    static final PdfName OUTLINES = new PdfName("Outlines");
    public static final PdfName OUTPUTCONDITION = new PdfName("OutputCondition");
    public static final PdfName OUTPUTCONDITIONIDENTIFIER = new PdfName("OutputConditionIdentifier");
    public static final PdfName OUTPUTINTENT = new PdfName("OutputIntent");
    public static final PdfName OUTPUTINTENTS = new PdfName("OutputIntents");
    public static final PdfName P = new PdfName("P");
    static final PdfName PAGE = new PdfName("Page");
    static final PdfName PAGELABELS = new PdfName("PageLabels");
    public static final PdfName PAGELAYOUT = new PdfName("PageLayout");
    public static final PdfName PAGEMODE = new PdfName("PageMode");
    static final PdfName PAGES = new PdfName("Pages");
    static final PdfName PAINTTYPE = new PdfName("PaintType");
    static final PdfName PANOSE = new PdfName("Panose");
    static final PdfName PARAMS = new PdfName("Params");
    static final PdfName PARENT = new PdfName("Parent");
    static final PdfName PARENTTREE = new PdfName("ParentTree");
    static final PdfName PATTERN = new PdfName("Pattern");
    static final PdfName PATTERNTYPE = new PdfName("PatternType");
    public static final PdfName PERCEPTUAL = new PdfName("Perceptual");
    static final PdfName PERMS = new PdfName("Perms");
    public static final PdfName PICKTRAYBYPDFSIZE = new PdfName("PickTrayByPDFSize");
    static final PdfName POPUP = new PdfName("Popup");
    public static final PdfName PREDICTOR = new PdfName("Predictor");
    static final PdfName PREV = new PdfName("Prev");
    static final PdfName PREVPAGE = new PdfName("PrevPage");
    static final PdfName PRINT = new PdfName("Print");
    public static final PdfName PRINTAREA = new PdfName("PrintArea");
    public static final PdfName PRINTCLIP = new PdfName("PrintClip");
    public static final PdfName PRINTPAGERANGE = new PdfName("PrintPageRange");
    public static final PdfName PRINTSCALING = new PdfName("PrintScaling");
    static final PdfName PROCSET = new PdfName("ProcSet");
    public static final PdfName PRODUCER = new PdfName("Producer");
    static final PdfName PROPERTIES = new PdfName("Properties");
    static final PdfName PUBSEC = new PdfName("Adobe.PubSec");
    static final PdfName Q = new PdfName("Q");
    static final PdfName R = new PdfName("R");
    public static final PdfName R2L = new PdfName("R2L");
    static final PdfName RANGE = new PdfName("Range");
    static final PdfName RC = new PdfName("RC");
    static final PdfName RBGROUPS = new PdfName("RBGroups");
    static final PdfName REASON = new PdfName("Reason");
    static final PdfName RECIPIENTS = new PdfName("Recipients");
    public static final PdfName RECT = new PdfName("Rect");
    static final PdfName REFERENCE = new PdfName("Reference");
    static final PdfName REGISTRY = new PdfName("Registry");
    public static final PdfName REGISTRYNAME = new PdfName("RegistryName");
    public static final PdfName RELATIVECOLORIMETRIC = new PdfName("RelativeColorimetric");
    static final PdfName RENDITION = new PdfName("Rendition");
    public static final PdfName RESOURCES = new PdfName("Resources");
    static final PdfName RI = new PdfName("RI");
    static final PdfName ROOT = new PdfName("Root");
    static final PdfName ROTATE = new PdfName("Rotate");
    static final PdfName ROWS = new PdfName("Rows");
    static final PdfName RV = new PdfName("RV");
    public static final PdfName S = new PdfName("S");
    public static final PdfName SATURATION = new PdfName("Saturation");
    public static final PdfName SCHEMA = new PdfName("Schema");
    static final PdfName SCREEN = new PdfName("Screen");
    static final PdfName SEPARATION = new PdfName("Separation");
    static final PdfName SHADING = new PdfName("Shading");
    static final PdfName SHADINGTYPE = new PdfName("ShadingType");
    static final PdfName SHIFT_JIS = new PdfName("Shift-JIS");
    static final PdfName SIG = new PdfName("Sig");
    static final PdfName SIGFLAGS = new PdfName("SigFlags");
    static final PdfName SIGREF = new PdfName("SigRef");
    public static final PdfName SIMPLEX = new PdfName("Simplex");
    public static final PdfName SINGLEPAGE = new PdfName("SinglePage");
    static final PdfName SIZE = new PdfName("Size");
    public static final PdfName SMASK = new PdfName("SMask");
    public static final PdfName SORT = new PdfName("Sort");
    static final PdfName SPLIT = new PdfName("Split");
    static final PdfName ST = new PdfName("St");
    static final PdfName STANDARD = new PdfName("Standard");
    static final PdfName STDCF = new PdfName("StdCF");
    static final PdfName STEMV = new PdfName("StemV");
    static final PdfName STMF = new PdfName("StmF");
    static final PdfName STRF = new PdfName("StrF");
    static final PdfName STRUCTPARENT = new PdfName("StructParent");
    static final PdfName STRUCTPARENTS = new PdfName("StructParents");
    static final PdfName STRUCTTREEROOT = new PdfName("StructTreeRoot");
    static final PdfName STYLE = new PdfName("Style");
    static final PdfName SUBFILTER = new PdfName("SubFilter");
    public static final PdfName SUBJECT = new PdfName("Subject");
    static final PdfName SUBTYPE = new PdfName("Subtype");
    static final PdfName SUPPLEMENT = new PdfName("Supplement");
    static final PdfName SV = new PdfName("SV");
    static final PdfName SW = new PdfName("SW");
    static final PdfName SYMBOL = new PdfName("Symbol");
    public static final PdfName T = new PdfName("T");
    static final PdfName TABS = new PdfName("Tabs");
    static final PdfName TEXT = new PdfName("Text");
    static final PdfName THUMB = new PdfName("Thumb");
    static final PdfName TI = new PdfName("TI");
    static final PdfName TILINGTYPE = new PdfName("TilingType");
    static final PdfName TIMES_ROMAN = new PdfName("Times-Roman");
    static final PdfName TIMES_BOLD = new PdfName("Times-Bold");
    static final PdfName TIMES_ITALIC = new PdfName("Times-Italic");
    static final PdfName TIMES_BOLDITALIC = new PdfName("Times-BoldItalic");
    public static final PdfName TITLE = new PdfName("Title");
    static final PdfName TK = new PdfName("TK");
    static final PdfName TM = new PdfName("TM");
    static final PdfName TOUNICODE = new PdfName("ToUnicode");
    static final PdfName TP = new PdfName("TP");
    static final PdfName TRANS = new PdfName("Trans");
    static final PdfName TRANSFORMPARAMS = new PdfName("TransformParams");
    static final PdfName TRANSFORMMETHOD = new PdfName("TransformMethod");
    static final PdfName TRANSPARENCY = new PdfName("Transparency");
    public static final PdfName TRAPPED = new PdfName("Trapped");
    public static final PdfName TRIMBOX = new PdfName("TrimBox");
    static final PdfName TRUETYPE = new PdfName("TrueType");
    public static final PdfName TU = new PdfName("TU");
    public static final PdfName TWOCOLUMNLEFT = new PdfName("TwoColumnLeft");
    public static final PdfName TWOCOLUMNRIGHT = new PdfName("TwoColumnRight");
    public static final PdfName TWOPAGELEFT = new PdfName("TwoPageLeft");
    public static final PdfName TWOPAGERIGHT = new PdfName("TwoPageRight");
    static final PdfName TX = new PdfName("Tx");
    static final PdfName TYPE = new PdfName("Type");
    static final PdfName TYPE0 = new PdfName("Type0");
    static final PdfName TYPE1 = new PdfName("Type1");
    static final PdfName U = new PdfName("U");
    static final PdfName UF = new PdfName("UF");
    static final PdfName UHC = new PdfName("UHC");
    static final PdfName UR = new PdfName("UR");
    static final PdfName UR3 = new PdfName("UR3");
    static final PdfName URI = new PdfName("URI");
    static final PdfName USAGE = new PdfName("Usage");
    public static final PdfName USEATTACHMENTS = new PdfName("UseAttachments");
    public static final PdfName USENONE = new PdfName("UseNone");
    public static final PdfName USEOC = new PdfName("UseOC");
    public static final PdfName USEOUTLINES = new PdfName("UseOutlines");
    static final PdfName USERPROPERTIES = new PdfName("UserProperties");
    static final PdfName USERUNIT = new PdfName("UserUnit");
    public static final PdfName USETHUMBS = new PdfName("UseThumbs");
    public static final PdfName V = new PdfName("V");
    static final PdfName V2 = new PdfName("V2");
    static final PdfName VERISIGN_PPKVS = new PdfName("VeriSign.PPKVS");
    public static final PdfName VERSION = new PdfName("Version");
    static final PdfName VIEW = new PdfName("View");
    public static final PdfName VIEWAREA = new PdfName("ViewArea");
    public static final PdfName VIEWCLIP = new PdfName("ViewClip");
    public static final PdfName VIEWERPREFERENCES = new PdfName("ViewerPreferences");
    static final PdfName VIEWSTATE = new PdfName("ViewState");
    static final PdfName VISIBLEPAGES = new PdfName("VisiblePages");
    static final PdfName W = new PdfName("W");
    static final PdfName W2 = new PdfName("W2");
    static final PdfName WC = new PdfName("WC");
    static final PdfName WIDGET = new PdfName("Widget");
    static final PdfName WIDTH = new PdfName("Width");
    static final PdfName WIDTHS = new PdfName("Widths");
    static final PdfName WIN = new PdfName("Win");
    static final PdfName WIN_ANSI_ENCODING = new PdfName("WinAnsiEncoding");
    static final PdfName WIPE = new PdfName("Wipe");
    public static final PdfName WHITEPOINT = new PdfName("WhitePoint");
    static final PdfName WP = new PdfName("WP");
    static final PdfName WS = new PdfName("WS");
    static final PdfName XFA = new PdfName("XFA");
    static final PdfName XML = new PdfName("XML");
    static final PdfName XOBJECT = new PdfName("XObject");
    static final PdfName XSTEP = new PdfName("XStep");
    static final PdfName XREF = new PdfName("XRef");
    static final PdfName XREFSTM = new PdfName("XRefStm");
    static final PdfName XYZ = new PdfName("XYZ");
    static final PdfName YSTEP = new PdfName("YStep");
    static final PdfName ZADB = new PdfName("ZaDb");
    static final PdfName ZAPFDINGBATS = new PdfName("ZapfDingbats");
    static final PdfName ZOOM = new PdfName("Zoom");
    static Map staticNames;
    private int hash = 0;

    public PdfName(String string) {
        this(string, true);
    }

    PdfName(String string, boolean bl) {
        super(4);
        int n = string.length();
        if (bl && n > 127) {
            throw new IllegalArgumentException("The name '" + string + "' is too long (" + n + " characters).");
        }
        this.bytes = PdfName.encodeName(string);
    }

    PdfName(byte[] byArray) {
        super(4, byArray);
    }

    public int compareTo(Object object) {
        PdfName pdfName = (PdfName)object;
        byte[] byArray = this.bytes;
        byte[] byArray2 = pdfName.bytes;
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PdfName) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = 0;
            int n3 = this.bytes.length;
            for (int i = 0; i < n3; ++i) {
                n = 31 * n + (this.bytes[n2++] & 0xFF);
            }
            this.hash = n;
        }
        return n;
    }

    private static byte[] encodeName(String string) {
        int n = string.length();
        ByteBuffer byteBuffer = new ByteBuffer(n + 20);
        byteBuffer.append('/');
        char[] cArray = string.toCharArray();
        block3: for (int i = 0; i < n; ++i) {
            char c = (char)(cArray[i] & 0xFF);
            switch (c) {
                case ' ': 
                case '#': 
                case '%': 
                case '(': 
                case ')': 
                case '/': 
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    byteBuffer.append('#');
                    byteBuffer.append(Integer.toString(c, 16));
                    continue block3;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        byteBuffer.append(c);
                        continue block3;
                    }
                    byteBuffer.append('#');
                    if (c < '\u0010') {
                        byteBuffer.append('0');
                    }
                    byteBuffer.append(Integer.toString(c, 16));
                }
            }
        }
        return byteBuffer.toByteArray();
    }

    static String decodeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '#') {
                    char c2 = string.charAt(i + 1);
                    char c3 = string.charAt(i + 2);
                    c = (char)((PRTokeniser.getHex(c2) << 4) + PRTokeniser.getHex(c3));
                    i += 2;
                }
                stringBuffer.append(c);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    static {
        Field[] fieldArray = PdfName.class.getDeclaredFields();
        staticNames = new LinkedHashMap(fieldArray.length);
        try {
            for (Field field : fieldArray) {
                if ((field.getModifiers() & 0x19) != 25 || !field.getType().equals(PdfName.class)) continue;
                PdfName pdfName = (PdfName)field.get(null);
                staticNames.put(PdfName.decodeName(pdfName.toString()), pdfName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

