/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import java.util.ArrayList;

class PdfLayer
extends PdfDictionary
implements PdfOCG {
    private PdfIndirectReference ref;
    private ArrayList children;
    private PdfLayer parent;
    private final String title;
    private boolean on = true;
    private boolean onPanel = true;

    PdfLayer(String string) {
        this.title = string;
    }

    String getTitle() {
        return this.title;
    }

    void addChild(PdfLayer pdfLayer) {
        if (pdfLayer.parent != null) {
            throw new IllegalArgumentException("The layer '" + ((PdfString)pdfLayer.get(PdfName.NAME)).toUnicodeString() + "' already has a parent.");
        }
        pdfLayer.parent = this;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(pdfLayer);
    }

    public PdfLayer getParent() {
        return this.parent;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    @Override
    public PdfIndirectReference getRef() {
        return this.ref;
    }

    void setRef(PdfIndirectReference pdfIndirectReference) {
        this.ref = pdfIndirectReference;
    }

    public void setName(String string) {
        this.put(PdfName.NAME, new PdfString(string, "UnicodeBig"));
    }

    @Override
    public PdfObject getPdfObject() {
        return this;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean bl) {
        this.on = bl;
    }

    private PdfDictionary getUsage() {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.USAGE);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
            this.put(PdfName.USAGE, pdfDictionary);
        }
        return pdfDictionary;
    }

    public void setExport(boolean bl) {
        PdfDictionary pdfDictionary = this.getUsage();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.EXPORTSTATE, bl ? PdfName.ON : PdfName.OFF);
        pdfDictionary.put(PdfName.EXPORT, pdfDictionary2);
    }

    public void setView(boolean bl) {
        PdfDictionary pdfDictionary = this.getUsage();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.VIEWSTATE, bl ? PdfName.ON : PdfName.OFF);
        pdfDictionary.put(PdfName.VIEW, pdfDictionary2);
    }

    public boolean isOnPanel() {
        return this.onPanel;
    }

    public void setOnPanel(boolean bl) {
        this.onPanel = bl;
    }
}

