/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PdfImage
extends PdfStream {
    private static final int TRANSFERSIZE = 4096;
    private PdfName name = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PdfImage(Image image, String string, PdfIndirectReference pdfIndirectReference) throws BadPdfFormatException {
        this.name = new PdfName(string);
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.IMAGE);
        this.put(PdfName.WIDTH, new PdfNumber(image.getWidth()));
        this.put(PdfName.HEIGHT, new PdfNumber(image.getHeight()));
        if (image.getLayer() != null) {
            this.put(PdfName.OC, image.getLayer().getRef());
        }
        if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 255)) {
            this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
        }
        if (pdfIndirectReference != null) {
            if (image.isSmask()) {
                this.put(PdfName.SMASK, pdfIndirectReference);
            } else {
                this.put(PdfName.MASK, pdfIndirectReference);
            }
        }
        if (image.isMask() && image.isInverted()) {
            this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
        }
        if (image.isInterpolation()) {
            this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
        }
        InputStream inputStream = null;
        try {
            String string2;
            if (image.isImgRaw()) {
                Object object;
                int n = image.getColorspace();
                int[] nArray = image.getTransparency();
                if (nArray != null && !image.isMask() && pdfIndirectReference == null) {
                    String string3 = "[";
                    object = nArray;
                    int n2 = ((int[])object).length;
                    for (int i = 0; i < n2; ++i) {
                        int n3 = object[i];
                        string3 = string3 + n3 + " ";
                    }
                    string3 = string3 + "]";
                    this.put(PdfName.MASK, new PdfLiteral(string3));
                }
                this.bytes = image.getRawData();
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                int n4 = image.getBpc();
                if (n4 > 255) {
                    if (!image.isMask()) {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                    this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                    int n5 = n4 - 257;
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    if (n5 != 0) {
                        pdfDictionary.put(PdfName.K, new PdfNumber(n5));
                    }
                    if ((n & 1) != 0) {
                        pdfDictionary.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                    }
                    if ((n & 2) != 0) {
                        pdfDictionary.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                    }
                    if ((n & 4) != 0) {
                        pdfDictionary.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                    }
                    if ((n & 8) != 0) {
                        pdfDictionary.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                    }
                    pdfDictionary.put(PdfName.COLUMNS, new PdfNumber(image.getWidth()));
                    pdfDictionary.put(PdfName.ROWS, new PdfNumber(image.getHeight()));
                    this.put(PdfName.DECODEPARMS, pdfDictionary);
                    return;
                }
                switch (n) {
                    case 1: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                        if (!image.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                        break;
                    }
                    case 3: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                        if (!image.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0]"));
                        break;
                    }
                    default: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                        if (!image.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                    }
                }
                if ((object = (Object)image.getAdditional()) != null) {
                    this.putAll((PdfDictionary)object);
                }
                if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 8)) {
                    this.remove(PdfName.COLORSPACE);
                }
                this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(image.getBpc()));
                if (image.isDeflated()) {
                    this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                    return;
                }
                this.flateCompress(image.getCompressionLevel());
                return;
            }
            if (image.getRawData() == null) {
                inputStream = image.getUrl().openStream();
                string2 = image.getUrl().toString();
            } else {
                inputStream = new ByteArrayInputStream(image.getRawData());
                string2 = "Byte array";
            }
            switch (image.type()) {
                case 32: {
                    this.put(PdfName.FILTER, PdfName.DCTDECODE);
                    switch (image.getColorspace()) {
                        case 1: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                            break;
                        }
                        case 3: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                            break;
                        }
                        default: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            if (!image.isInverted()) break;
                            this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                        }
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                    if (image.getRawData() != null) {
                        this.bytes = image.getRawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        return;
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    PdfImage.transferBytes(inputStream, this.streamBytes, -1);
                    break;
                }
                case 33: {
                    this.put(PdfName.FILTER, PdfName.JPXDECODE);
                    if (image.getColorspace() > 0) {
                        switch (image.getColorspace()) {
                            case 1: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                break;
                            }
                            case 3: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                break;
                            }
                            default: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            }
                        }
                        this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(image.getBpc()));
                    }
                    if (image.getRawData() != null) {
                        this.bytes = image.getRawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        return;
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    PdfImage.transferBytes(inputStream, this.streamBytes, -1);
                    break;
                }
                case 36: {
                    this.put(PdfName.FILTER, PdfName.JBIG2DECODE);
                    this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                    if (image.getRawData() != null) {
                        this.bytes = image.getRawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        return;
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    PdfImage.transferBytes(inputStream, this.streamBytes, -1);
                    break;
                }
                default: {
                    throw new BadPdfFormatException(string2 + " is an unknown Image format.");
                }
            }
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            return;
        }
        catch (IOException iOException) {
            throw new BadPdfFormatException(iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    PdfName name() {
        return this.name;
    }

    private static void transferBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4096];
        if (n < 0) {
            n = 0x7FFFFFF;
        }
        while (n != 0) {
            int n2 = inputStream.read(byArray, 0, Math.min(n, 4096));
            if (n2 < 0) {
                return;
            }
            outputStream.write(byArray, 0, n2);
            n -= n2;
        }
    }
}

