/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfSignature;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;

public class PdfFormField
extends PdfAnnotation {
    static final int FF_READ_ONLY = 1;
    static final int FF_REQUIRED = 2;
    private static final int FF_NO_TOGGLE_TO_OFF = 16384;
    static final int FF_RADIO = 32768;
    static final int FF_PUSHBUTTON = 65536;
    static final int FF_MULTILINE = 4096;
    static final int FF_PASSWORD = 8192;
    static final int FF_COMBO = 131072;
    static final int FF_EDIT = 262144;
    static final int FF_FILESELECT = 0x100000;
    static final int FF_DONOTSPELLCHECK = 0x400000;
    static final int FF_DONOTSCROLL = 0x800000;
    static final int FF_COMB = 0x1000000;
    static final int FF_RADIOSINUNISON = 0x2000000;
    static final int Q_CENTER = 1;
    static final int Q_RIGHT = 2;
    private static PdfName[] mergeTarget = new PdfName[]{PdfName.FONT, PdfName.XOBJECT, PdfName.COLORSPACE, PdfName.PATTERN};
    private PdfFormField parent;
    private ArrayList kids;

    private PdfFormField(PdfWriter pdfWriter) {
        super(pdfWriter, null);
        this.form = true;
        this.annotation = false;
    }

    void setWidget(Rectangle rectangle, PdfName pdfName) {
        this.put(PdfName.TYPE, PdfName.ANNOT);
        this.put(PdfName.SUBTYPE, PdfName.WIDGET);
        this.put(PdfName.RECT, new PdfRectangle(rectangle));
        this.annotation = true;
        if (pdfName != null && !pdfName.equals(HIGHLIGHT_INVERT)) {
            this.put(PdfName.H, pdfName);
        }
    }

    static PdfFormField createEmpty(PdfWriter pdfWriter) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        return pdfFormField;
    }

    public void setButton(int n) {
        this.put(PdfName.FT, PdfName.BTN);
        if (n != 0) {
            this.put(PdfName.FF, new PdfNumber(n));
        }
    }

    private static PdfFormField createButton(PdfWriter pdfWriter, int n) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.setButton(n);
        return pdfFormField;
    }

    static PdfFormField createPushButton(PdfWriter pdfWriter) {
        return PdfFormField.createButton(pdfWriter, 65536);
    }

    static PdfFormField createCheckBox(PdfWriter pdfWriter) {
        return PdfFormField.createButton(pdfWriter, 0);
    }

    static PdfFormField createRadioButton(PdfWriter pdfWriter, boolean bl) {
        return PdfFormField.createButton(pdfWriter, 32768 + (bl ? 16384 : 0));
    }

    static PdfFormField createTextField(PdfWriter pdfWriter, boolean bl, boolean bl2, int n) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.put(PdfName.FT, PdfName.TX);
        int n2 = bl ? 4096 : 0;
        pdfFormField.put(PdfName.FF, new PdfNumber(n2 += bl2 ? 8192 : 0));
        if (n > 0) {
            pdfFormField.put(PdfName.MAXLEN, new PdfNumber(n));
        }
        return pdfFormField;
    }

    private static PdfFormField createChoice(PdfWriter pdfWriter, int n, PdfArray pdfArray, int n2) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.put(PdfName.FT, PdfName.CH);
        pdfFormField.put(PdfName.FF, new PdfNumber(n));
        pdfFormField.put(PdfName.OPT, pdfArray);
        if (n2 > 0) {
            pdfFormField.put(PdfName.TI, new PdfNumber(n2));
        }
        return pdfFormField;
    }

    static PdfFormField createList(PdfWriter pdfWriter, String[] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 0, PdfFormField.processOptions(stringArray), n);
    }

    static PdfFormField createList(PdfWriter pdfWriter, String[][] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 0, PdfFormField.processOptions(stringArray), n);
    }

    static PdfFormField createCombo(PdfWriter pdfWriter, boolean bl, String[] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 131072 + (bl ? 262144 : 0), PdfFormField.processOptions(stringArray), n);
    }

    static PdfFormField createCombo(PdfWriter pdfWriter, boolean bl, String[][] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 131072 + (bl ? 262144 : 0), PdfFormField.processOptions(stringArray), n);
    }

    private static PdfArray processOptions(String[] stringArray) {
        PdfArray pdfArray = new PdfArray();
        for (String string : stringArray) {
            pdfArray.add(new PdfString(string, "UnicodeBig"));
        }
        return pdfArray;
    }

    private static PdfArray processOptions(String[][] stringArray) {
        PdfArray pdfArray = new PdfArray();
        for (String[] stringArray2 : stringArray) {
            PdfArray pdfArray2 = new PdfArray(new PdfString(stringArray2[0], "UnicodeBig"));
            pdfArray2.add(new PdfString(stringArray2[1], "UnicodeBig"));
            pdfArray.add(pdfArray2);
        }
        return pdfArray;
    }

    static PdfFormField createSignature(PdfWriter pdfWriter) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.put(PdfName.FT, PdfName.SIG);
        return pdfFormField;
    }

    public PdfFormField getParent() {
        return this.parent;
    }

    public void addKid(PdfFormField pdfFormField) {
        pdfFormField.parent = this;
        if (this.kids == null) {
            this.kids = new ArrayList();
        }
        this.kids.add(pdfFormField);
    }

    public ArrayList getKids() {
        return this.kids;
    }

    int setFieldFlags(int n) {
        PdfNumber pdfNumber = (PdfNumber)this.get(PdfName.FF);
        int n2 = pdfNumber == null ? 0 : pdfNumber.intValue();
        int n3 = n2 | n;
        this.put(PdfName.FF, new PdfNumber(n3));
        return n2;
    }

    public void setValueAsString(String string) {
        this.put(PdfName.V, new PdfString(string, "UnicodeBig"));
    }

    public void setValueAsName(String string) {
        this.put(PdfName.V, new PdfName(string));
    }

    public void setValue(PdfSignature pdfSignature) {
        this.put(PdfName.V, pdfSignature);
    }

    public void setDefaultValueAsString(String string) {
        this.put(PdfName.DV, new PdfString(string, "UnicodeBig"));
    }

    public void setDefaultValueAsName(String string) {
        this.put(PdfName.DV, new PdfName(string));
    }

    public void setFieldName(String string) {
        if (string != null) {
            this.put(PdfName.T, new PdfString(string, "UnicodeBig"));
        }
    }

    public void setUserName(String string) {
        this.put(PdfName.TU, new PdfString(string, "UnicodeBig"));
    }

    public void setMappingName(String string) {
        this.put(PdfName.TM, new PdfString(string, "UnicodeBig"));
    }

    public void setQuadding(int n) {
        this.put(PdfName.Q, new PdfNumber(n));
    }

    static void mergeResources(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfStamperImp pdfStamperImp) {
        PdfDictionary pdfDictionary3 = null;
        PdfDictionary pdfDictionary4 = null;
        PdfName pdfName = null;
        for (PdfName pdfName2 : mergeTarget) {
            pdfName = pdfName2;
            PdfDictionary pdfDictionary5 = pdfDictionary2.getAsDict(pdfName);
            pdfDictionary3 = pdfDictionary5;
            if (pdfDictionary3 == null) continue;
            pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(pdfName), pdfDictionary);
            if (pdfDictionary4 == null) {
                pdfDictionary4 = new PdfDictionary();
            }
            pdfDictionary4.mergeDifferent(pdfDictionary3);
            pdfDictionary.put(pdfName, pdfDictionary4);
            if (pdfStamperImp == null) continue;
            pdfStamperImp.markUsed(pdfDictionary4);
        }
    }

    static void mergeResources(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        PdfFormField.mergeResources(pdfDictionary, pdfDictionary2, null);
    }

    @Override
    public void setUsed() {
        PdfObject pdfObject;
        this.used = true;
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.getIndirectReference());
        }
        if (this.kids != null) {
            pdfObject = new PdfArray();
            for (int i = 0; i < this.kids.size(); ++i) {
                ((PdfArray)pdfObject).add(((PdfFormField)this.kids.get(i)).getIndirectReference());
            }
            this.put(PdfName.KIDS, pdfObject);
        }
        if (this.templates == null) {
            return;
        }
        pdfObject = new PdfDictionary();
        for (PdfTemplate pdfTemplate : this.templates.keySet()) {
            PdfFormField.mergeResources((PdfDictionary)pdfObject, (PdfDictionary)pdfTemplate.getResources());
        }
        this.put(PdfName.DR, pdfObject);
    }

    static PdfAnnotation shallowDuplicate(PdfAnnotation pdfAnnotation) {
        PdfAnnotation pdfAnnotation2;
        if (pdfAnnotation.isForm()) {
            pdfAnnotation2 = new PdfFormField(pdfAnnotation.writer);
            PdfFormField pdfFormField = pdfAnnotation2;
            PdfFormField pdfFormField2 = (PdfFormField)pdfAnnotation;
            pdfFormField.parent = pdfFormField2.parent;
            pdfFormField.kids = pdfFormField2.kids;
        } else {
            pdfAnnotation2 = new PdfAnnotation(pdfAnnotation.writer, null);
        }
        pdfAnnotation2.merge(pdfAnnotation);
        pdfAnnotation2.form = pdfAnnotation.form;
        pdfAnnotation2.annotation = pdfAnnotation.annotation;
        pdfAnnotation2.templates = pdfAnnotation.templates;
        return pdfAnnotation2;
    }
}

