/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class PdfDictionary
extends PdfObject {
    private static final PdfName FONT = PdfName.FONT;
    static final PdfName OUTLINES = PdfName.OUTLINES;
    static final PdfName PAGE = PdfName.PAGE;
    private static final PdfName PAGES = PdfName.PAGES;
    static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected HashMap<PdfName, PdfObject> hashMap = new LinkedHashMap<PdfName, PdfObject>();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName pdfName) {
        this();
        this.dictionaryType = pdfName;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    @Override
    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        outputStream.write(60);
        outputStream.write(60);
        int n = 0;
        Iterator<PdfName> iterator = this.hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName;
            PdfName pdfName2 = pdfName = iterator.next();
            PdfObject pdfObject = this.hashMap.get(pdfName2);
            pdfName2.toPdf(pdfWriter, outputStream);
            n = pdfObject.type();
            if (n != 5 && n != 6 && n != 4 && n != 3) {
                outputStream.write(32);
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        outputStream.write(62);
        outputStream.write(62);
    }

    @Override
    public String toString() {
        if (this.get(PdfName.TYPE) == null) {
            return "Dictionary";
        }
        return "Dictionary of type: " + this.get(PdfName.TYPE);
    }

    public void put(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.hashMap.remove(pdfName);
        } else {
            this.hashMap.put(pdfName, pdfObject);
        }
    }

    void putAll(PdfDictionary pdfDictionary) {
        this.hashMap.putAll(pdfDictionary.hashMap);
    }

    public void remove(PdfName pdfName) {
        this.hashMap.remove(pdfName);
    }

    public PdfObject get(PdfName pdfName) {
        return this.hashMap.get(pdfName);
    }

    public PdfObject getDirectObject(PdfName pdfName) {
        return PdfReader.getPdfObject(this.get(pdfName));
    }

    public Set<PdfName> getKeys() {
        return this.hashMap.keySet();
    }

    public int size() {
        return this.hashMap.size();
    }

    boolean contains(PdfName pdfName) {
        return this.hashMap.containsKey(pdfName);
    }

    public boolean isFont() {
        return FONT.equals(this.dictionaryType);
    }

    public boolean isPage() {
        return PAGE.equals(this.dictionaryType);
    }

    public boolean isPages() {
        return PAGES.equals(this.dictionaryType);
    }

    public boolean isCatalog() {
        return CATALOG.equals(this.dictionaryType);
    }

    public boolean isOutlineTree() {
        return OUTLINES.equals(this.dictionaryType);
    }

    void merge(PdfDictionary pdfDictionary) {
        this.hashMap.putAll(pdfDictionary.hashMap);
    }

    void mergeDifferent(PdfDictionary pdfDictionary) {
        for (PdfName pdfName : pdfDictionary.hashMap.keySet()) {
            if (this.hashMap.containsKey(pdfName)) continue;
            this.hashMap.put(pdfName, pdfDictionary.hashMap.get(pdfName));
        }
    }

    public PdfDictionary getAsDict(PdfName pdfName) {
        PdfDictionary pdfDictionary = null;
        PdfObject pdfObject = this.getDirectObject(pdfName);
        if (pdfObject != null && pdfObject.isDictionary()) {
            pdfDictionary = (PdfDictionary)pdfObject;
        }
        return pdfDictionary;
    }

    public PdfArray getAsArray(PdfName pdfName) {
        PdfArray pdfArray = null;
        PdfObject pdfObject = this.getDirectObject(pdfName);
        if (pdfObject != null && pdfObject.isArray()) {
            pdfArray = (PdfArray)pdfObject;
        }
        return pdfArray;
    }

    public PdfString getAsString(PdfName pdfName) {
        PdfString pdfString = null;
        PdfObject pdfObject = this.getDirectObject(pdfName);
        if (pdfObject != null && pdfObject.isString()) {
            pdfString = (PdfString)pdfObject;
        }
        return pdfString;
    }

    public PdfNumber getAsNumber(PdfName pdfName) {
        PdfNumber pdfNumber = null;
        PdfObject pdfObject = this.getDirectObject(pdfName);
        if (pdfObject != null && pdfObject.isNumber()) {
            pdfNumber = (PdfNumber)pdfObject;
        }
        return pdfNumber;
    }

    public PdfName getAsName(PdfName pdfName) {
        PdfName pdfName2 = null;
        PdfObject pdfObject = this.getDirectObject(pdfName);
        if (pdfObject != null && pdfObject.isName()) {
            pdfName2 = (PdfName)pdfObject;
        }
        return pdfName2;
    }

    PdfBoolean getAsBoolean(PdfName pdfName) {
        PdfBoolean pdfBoolean = null;
        PdfObject pdfObject = this.getDirectObject(pdfName);
        if (pdfObject != null && pdfObject.isBoolean()) {
            pdfBoolean = (PdfBoolean)pdfObject;
        }
        return pdfBoolean;
    }

    PdfIndirectReference getAsIndirectObject(PdfName pdfName) {
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject = this.get(pdfName);
        if (pdfObject != null && pdfObject.isIndirect()) {
            pdfIndirectReference = (PdfIndirectReference)pdfObject;
        }
        return pdfIndirectReference;
    }
}

