/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfBorderArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfColor;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class PdfAnnotation
extends PdfDictionary {
    static final PdfName HIGHLIGHT_INVERT = PdfName.I;
    static final PdfName HIGHLIGHT_TOGGLE = PdfName.T;
    static final int FLAGS_HIDDEN = 2;
    static final int FLAGS_PRINT = 4;
    static final int FLAGS_NOVIEW = 32;
    static final int FLAGS_LOCKED = 128;
    static final PdfName APPEARANCE_NORMAL = PdfName.N;
    private static final int MARKUP_UNDERLINE = 1;
    private static final int MARKUP_STRIKEOUT = 2;
    private static final int MARKUP_SQUIGGLY = 3;
    protected PdfWriter writer;
    private PdfIndirectReference reference;
    protected HashMap templates;
    protected boolean form = false;
    protected boolean annotation = true;
    protected boolean used = false;
    private int placeInPage = -1;

    PdfAnnotation(PdfWriter pdfWriter, Rectangle rectangle) {
        this.writer = pdfWriter;
        if (rectangle != null) {
            this.put(PdfName.RECT, new PdfRectangle(rectangle));
        }
    }

    public PdfAnnotation(PdfWriter pdfWriter, float f, float f2, float f3, float f4, PdfString pdfString, PdfString pdfString2) {
        this.writer = pdfWriter;
        this.put(PdfName.SUBTYPE, PdfName.TEXT);
        this.put(PdfName.T, pdfString);
        this.put(PdfName.RECT, new PdfRectangle(f, f2, f3, f4));
        this.put(PdfName.CONTENTS, pdfString2);
    }

    public PdfAnnotation(PdfWriter pdfWriter, float f, float f2, float f3, float f4, PdfAction pdfAction) {
        this.writer = pdfWriter;
        this.put(PdfName.SUBTYPE, PdfName.LINK);
        this.put(PdfName.RECT, new PdfRectangle(f, f2, f3, f4));
        this.put(PdfName.A, pdfAction);
        this.put(PdfName.BORDER, new PdfBorderArray(0.0f, 0.0f, 0.0f));
        this.put(PdfName.C, new PdfColor(0, 0, 255));
    }

    public static PdfAnnotation createScreen(PdfWriter pdfWriter, Rectangle rectangle, String string, PdfFileSpecification pdfFileSpecification, String string2, boolean bl) throws IOException {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.SCREEN);
        pdfAnnotation.put(PdfName.F, new PdfNumber(4));
        pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
        pdfAnnotation.setPage();
        PdfIndirectReference pdfIndirectReference = pdfAnnotation.getIndirectReference();
        PdfAction pdfAction = PdfAction.rendition(string, pdfFileSpecification, string2, pdfIndirectReference);
        PdfIndirectReference pdfIndirectReference2 = pdfWriter.addToBody(pdfAction).getIndirectReference();
        if (bl) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(new PdfName("PV"), pdfIndirectReference2);
            pdfAnnotation.put(PdfName.AA, pdfDictionary);
        }
        pdfAnnotation.put(PdfName.A, pdfIndirectReference2);
        return pdfAnnotation;
    }

    public PdfIndirectReference getIndirectReference() {
        if (this.reference == null) {
            this.reference = this.writer.getPdfIndirectReference();
        }
        return this.reference;
    }

    private static PdfAnnotation createLink(PdfWriter pdfWriter, Rectangle rectangle, PdfName pdfName) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.LINK);
        if (!pdfName.equals(HIGHLIGHT_INVERT)) {
            pdfAnnotation.put(PdfName.H, pdfName);
        }
        return pdfAnnotation;
    }

    private static PdfAnnotation createFileAttachment(PdfWriter pdfWriter, Rectangle rectangle, String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.FILEATTACHMENT);
        if (string != null) {
            pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        }
        pdfAnnotation.put(PdfName.FS, pdfFileSpecification.getReference());
        return pdfAnnotation;
    }

    public void setDefaultAppearanceString(PdfContentByte pdfContentByte) {
        byte[] byArray = pdfContentByte.getInternalBuffer().toByteArray();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 10) continue;
            byArray[i] = 32;
        }
        this.put(PdfName.DA, new PdfString(byArray));
    }

    public void setFlags(int n) {
        if (n == 0) {
            this.remove(PdfName.F);
        } else {
            this.put(PdfName.F, new PdfNumber(n));
        }
    }

    public void setBorder(PdfBorderArray pdfBorderArray) {
        this.put(PdfName.BORDER, pdfBorderArray);
    }

    public void setBorderStyle(PdfBorderDictionary pdfBorderDictionary) {
        this.put(PdfName.BS, pdfBorderDictionary);
    }

    public void setHighlighting(PdfName pdfName) {
        if (pdfName.equals(HIGHLIGHT_INVERT)) {
            this.remove(PdfName.H);
        } else {
            this.put(PdfName.H, pdfName);
        }
    }

    void setAppearance(PdfName pdfName, PdfTemplate pdfTemplate) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.AP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
        }
        pdfDictionary.put(pdfName, pdfTemplate.getIndirectReference());
        this.put(PdfName.AP, pdfDictionary);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new LinkedHashMap();
        }
        this.templates.put(pdfTemplate, null);
    }

    void setAppearance(PdfName pdfName, String string, PdfTemplate pdfTemplate) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.AP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
        }
        PdfDictionary pdfDictionary2 = (pdfObject = pdfDictionary.get(pdfName)) != null && pdfObject.isDictionary() ? (PdfDictionary)pdfObject : new PdfDictionary();
        pdfDictionary2.put(new PdfName(string), pdfTemplate.getIndirectReference());
        pdfDictionary.put(pdfName, pdfDictionary2);
        this.put(PdfName.AP, pdfDictionary);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new LinkedHashMap();
        }
        this.templates.put(pdfTemplate, null);
    }

    public void setAppearanceState(String string) {
        if (string == null) {
            this.remove(PdfName.AS);
            return;
        }
        this.put(PdfName.AS, new PdfName(string));
    }

    public void setColor(Color color) {
        this.put(PdfName.C, new PdfColor(color));
    }

    public void setTitle(String string) {
        if (string == null) {
            this.remove(PdfName.T);
            return;
        }
        this.put(PdfName.T, new PdfString(string, "UnicodeBig"));
    }

    public void setPopup(PdfAnnotation pdfAnnotation) {
        this.put(PdfName.POPUP, pdfAnnotation.getIndirectReference());
        pdfAnnotation.put(PdfName.PARENT, this.getIndirectReference());
    }

    public void setAction(PdfAction pdfAction) {
        this.put(PdfName.A, pdfAction);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed() {
        this.used = true;
    }

    public HashMap getTemplates() {
        return this.templates;
    }

    public boolean isForm() {
        return this.form;
    }

    public boolean isAnnotation() {
        return this.annotation;
    }

    public void setPage(int n) {
        this.put(PdfName.P, this.writer.getPageReference(n));
    }

    void setPage() {
        this.put(PdfName.P, this.writer.getCurrentPage());
    }

    public int getPlaceInPage() {
        return this.placeInPage;
    }

    public void setPlaceInPage(int n) {
        this.placeInPage = n;
    }

    public void setRotate(int n) {
        this.put(PdfName.ROTATE, new PdfNumber(n));
    }

    private PdfDictionary getMK() {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.MK);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
            this.put(PdfName.MK, pdfDictionary);
        }
        return pdfDictionary;
    }

    public void setMKRotation(int n) {
        this.getMK().put(PdfName.R, new PdfNumber(n));
    }

    private static PdfArray getMKColor(Color color) {
        PdfArray pdfArray = new PdfArray();
        int n = ExtendedColor.getType(color);
        switch (n) {
            case 1: {
                pdfArray.add(new PdfNumber(((GrayColor)color).getGray()));
                break;
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)color;
                pdfArray.add(new PdfNumber(cMYKColor.getCyan()));
                pdfArray.add(new PdfNumber(cMYKColor.getMagenta()));
                pdfArray.add(new PdfNumber(cMYKColor.getYellow()));
                pdfArray.add(new PdfNumber(cMYKColor.getBlack()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new RuntimeException("Separations, patterns and shadings are not allowed in MK dictionary.");
            }
            default: {
                pdfArray.add(new PdfNumber((float)color.getRed() / 255.0f));
                pdfArray.add(new PdfNumber((float)color.getGreen() / 255.0f));
                pdfArray.add(new PdfNumber((float)color.getBlue() / 255.0f));
            }
        }
        return pdfArray;
    }

    public void setMKBorderColor(Color color) {
        if (color == null) {
            this.getMK().remove(PdfName.BC);
        } else {
            this.getMK().put(PdfName.BC, PdfAnnotation.getMKColor(color));
        }
    }

    public void setMKBackgroundColor(Color color) {
        if (color == null) {
            this.getMK().remove(PdfName.BG);
        } else {
            this.getMK().put(PdfName.BG, PdfAnnotation.getMKColor(color));
        }
    }

    public void setMKNormalCaption(String string) {
        this.getMK().put(PdfName.CA, new PdfString(string, "UnicodeBig"));
    }

    public void setMKRolloverCaption(String string) {
        this.getMK().put(PdfName.RC, new PdfString(string, "UnicodeBig"));
    }

    public void setMKAlternateCaption(String string) {
        this.getMK().put(PdfName.AC, new PdfString(string, "UnicodeBig"));
    }

    public void setMKNormalIcon(PdfTemplate pdfTemplate) {
        this.getMK().put(PdfName.I, pdfTemplate.getIndirectReference());
    }

    public void setMKRolloverIcon(PdfTemplate pdfTemplate) {
        this.getMK().put(PdfName.RI, pdfTemplate.getIndirectReference());
    }

    public void setMKAlternateIcon(PdfTemplate pdfTemplate) {
        this.getMK().put(PdfName.IX, pdfTemplate.getIndirectReference());
    }

    void setMKIconFit(PdfName pdfName, PdfName pdfName2, float f, float f2, boolean bl) {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (!pdfName.equals(PdfName.A)) {
            pdfDictionary.put(PdfName.SW, pdfName);
        }
        if (!pdfName2.equals(PdfName.P)) {
            pdfDictionary.put(PdfName.S, pdfName2);
        }
        if (f != 0.5f || f2 != 0.5f) {
            PdfArray pdfArray = new PdfArray(new PdfNumber(f));
            pdfArray.add(new PdfNumber(f2));
            pdfDictionary.put(PdfName.A, pdfArray);
        }
        if (bl) {
            pdfDictionary.put(PdfName.FB, PdfBoolean.PDFTRUE);
        }
        this.getMK().put(PdfName.IF, pdfDictionary);
    }

    public void setMKTextPosition(int n) {
        this.getMK().put(PdfName.TP, new PdfNumber(n));
    }

    public void setLayer(PdfOCG pdfOCG) {
        this.put(PdfName.OC, pdfOCG.getRef());
    }

    public void setName(String string) {
        this.put(PdfName.NM, new PdfString(string));
    }
}

