/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRendition;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.collection.PdfTargetDictionary;
import java.io.IOException;
import java.net.URL;

public class PdfAction
extends PdfDictionary {
    private static final int FIRSTPAGE = 1;
    private static final int PREVPAGE = 2;
    private static final int NEXTPAGE = 3;
    private static final int LASTPAGE = 4;
    private static final int PRINTDIALOG = 5;

    public PdfAction() {
    }

    public PdfAction(URL uRL) {
        this(uRL.toExternalForm());
    }

    public PdfAction(String string) {
        this(string, false);
    }

    private PdfAction(String string, boolean bl) {
        this.put(PdfName.S, PdfName.URI);
        this.put(PdfName.URI, new PdfString(string));
        if (bl) {
            this.put(PdfName.ISMAP, PdfBoolean.PDFTRUE);
        }
    }

    PdfAction(PdfIndirectReference pdfIndirectReference) {
        this.put(PdfName.S, PdfName.GOTO);
        this.put(PdfName.D, pdfIndirectReference);
    }

    public PdfAction(String string, String string2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfString(string2));
    }

    public PdfAction(String string, int n) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfLiteral("[" + (n - 1) + " /FitH 10000]"));
    }

    public PdfAction(int n) {
        this.put(PdfName.S, PdfName.NAMED);
        switch (n) {
            case 1: {
                this.put(PdfName.N, PdfName.FIRSTPAGE);
                break;
            }
            case 4: {
                this.put(PdfName.N, PdfName.LASTPAGE);
                break;
            }
            case 3: {
                this.put(PdfName.N, PdfName.NEXTPAGE);
                break;
            }
            case 2: {
                this.put(PdfName.N, PdfName.PREVPAGE);
                break;
            }
            case 5: {
                this.put(PdfName.S, PdfName.JAVASCRIPT);
                this.put(PdfName.JS, new PdfString("this.print(true);\r"));
                break;
            }
            default: {
                throw new RuntimeException("Invalid named action.");
            }
        }
    }

    public PdfAction(String string, String string2, String string3, String string4) {
        this.put(PdfName.S, PdfName.LAUNCH);
        if (string2 == null && string3 == null && string4 == null) {
            this.put(PdfName.F, new PdfString(string));
        } else {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.F, new PdfString(string));
            if (string2 != null) {
                pdfDictionary.put(PdfName.P, new PdfString(string2));
            }
            if (string3 != null) {
                pdfDictionary.put(PdfName.O, new PdfString(string3));
            }
            if (string4 != null) {
                pdfDictionary.put(PdfName.D, new PdfString(string4));
            }
            this.put(PdfName.WIN, pdfDictionary);
        }
    }

    static PdfAction rendition(String string, PdfFileSpecification pdfFileSpecification, String string2, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.RENDITION);
        pdfAction.put(PdfName.R, new PdfRendition(string, pdfFileSpecification, string2));
        pdfAction.put(new PdfName("OP"), new PdfNumber(0));
        pdfAction.put(new PdfName("AN"), pdfIndirectReference);
        return pdfAction;
    }

    static PdfAction javaScript(String string, PdfWriter pdfWriter, boolean bl) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.JAVASCRIPT);
        if (bl && string.length() < 50) {
            pdfAction.put(PdfName.JS, new PdfString(string, "UnicodeBig"));
        } else if (!bl && string.length() < 100) {
            pdfAction.put(PdfName.JS, new PdfString(string));
        } else {
            try {
                byte[] byArray = PdfEncodings.convertToBytes(string, bl ? "UnicodeBig" : "PDF");
                PdfStream pdfStream = new PdfStream(byArray);
                pdfStream.flateCompress(pdfWriter.getCompressionLevel());
                pdfAction.put(PdfName.JS, pdfWriter.addToBody(pdfStream).getIndirectReference());
            }
            catch (Exception exception) {
                pdfAction.put(PdfName.JS, new PdfString(string));
            }
        }
        return pdfAction;
    }

    private static PdfAction createHide(PdfObject pdfObject, boolean bl) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.HIDE);
        pdfAction.put(PdfName.T, pdfObject);
        if (!bl) {
            pdfAction.put(PdfName.H, PdfBoolean.PDFFALSE);
        }
        return pdfAction;
    }

    private static PdfArray buildArray(Object[] objectArray) {
        PdfArray pdfArray = new PdfArray();
        for (Object object : objectArray) {
            if (object instanceof String) {
                pdfArray.add(new PdfString((String)object));
                continue;
            }
            if (object instanceof PdfAnnotation) {
                pdfArray.add(((PdfAnnotation)object).getIndirectReference());
                continue;
            }
            throw new RuntimeException("The array must contain String or PdfAnnotation.");
        }
        return pdfArray;
    }

    private static PdfAction gotoEmbedded(String string, PdfTargetDictionary pdfTargetDictionary, PdfObject pdfObject, boolean bl) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.GOTOE);
        pdfAction.put(PdfName.T, pdfTargetDictionary);
        pdfAction.put(PdfName.D, pdfObject);
        pdfAction.put(PdfName.NEWWINDOW, new PdfBoolean(bl));
        if (string != null) {
            pdfAction.put(PdfName.F, new PdfString(string));
        }
        return pdfAction;
    }
}

