/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public class PdfAcroForm
extends PdfDictionary {
    private final PdfWriter writer;
    private final HashMap fieldTemplates = new LinkedHashMap();
    private final PdfArray documentFields = new PdfArray();
    private final PdfArray calculationOrder = new PdfArray();
    private int sigFlags = 0;

    public PdfAcroForm(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    public void setNeedAppearances(boolean bl) {
        this.put(PdfName.NEEDAPPEARANCES, new PdfBoolean(bl));
    }

    public void addFieldTemplates(HashMap hashMap) {
        this.fieldTemplates.putAll(hashMap);
    }

    public void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        this.documentFields.add(pdfIndirectReference);
    }

    public boolean isValid() {
        if (this.documentFields.size() == 0) {
            return false;
        }
        this.put(PdfName.FIELDS, this.documentFields);
        if (this.sigFlags != 0) {
            this.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
        }
        if (this.calculationOrder.size() > 0) {
            this.put(PdfName.CO, this.calculationOrder);
        }
        if (this.fieldTemplates.isEmpty()) {
            return true;
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        for (PdfTemplate pdfTemplate : this.fieldTemplates.keySet()) {
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources());
        }
        this.put(PdfName.DR, pdfDictionary);
        this.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        PdfDictionary pdfDictionary2 = (PdfDictionary)pdfDictionary.get(PdfName.FONT);
        if (pdfDictionary2 != null) {
            this.writer.eliminateFontSubset(pdfDictionary2);
        }
        return true;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.calculationOrder.add(pdfFormField.getIndirectReference());
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    private void addFormField(PdfFormField pdfFormField) {
        this.writer.addAnnotation(pdfFormField);
    }

    private void setButtonParams(PdfFormField pdfFormField, int n, String string, String string2) {
        pdfFormField.setButton(n);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setFieldName(string);
        if (string2 != null) {
            pdfFormField.setValueAsString(string2);
        }
    }

    private void drawButton(PdfFormField pdfFormField, String string, BaseFont baseFont, float f, float f2, float f3, float f4, float f5) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.writer, f4 - f2, f5 - f3);
        pdfAppearance.drawButton(0.0f, 0.0f, f4 - f2, f5 - f3, string, baseFont, f);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }

    private void setTextFieldParams(PdfFormField pdfFormField, String string, String string2, float f, float f2, float f3, float f4) {
        pdfFormField.setWidget(new Rectangle(f, f2, f3, f4), PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setValueAsString(string);
        pdfFormField.setDefaultValueAsString(string);
        pdfFormField.setFieldName(string2);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
    }

    private void drawSingleLineOfText(PdfFormField pdfFormField, String string, BaseFont baseFont, float f, float f2, float f3, float f4, float f5) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.writer, f4 - f2, f5 - f3);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(baseFont, f);
        pdfAppearance2.resetRGBColorFill();
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        pdfAppearance.drawTextField(0.0f, 0.0f, f4 - f2, f5 - f3);
        pdfAppearance.beginVariableText();
        pdfAppearance.saveState();
        pdfAppearance.rectangle(3.0f, 3.0f, f4 - f2 - 6.0f, f5 - f3 - 6.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f);
        pdfAppearance.resetRGBColorFill();
        pdfAppearance.setTextMatrix(4.0f, (f5 - f3) / 2.0f - f * 0.3f);
        pdfAppearance.showText(string);
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }

    private void drawMultiLineOfText(PdfFormField pdfFormField, String string, BaseFont baseFont, float f, float f2, float f3, float f4, float f5) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.writer, f4 - f2, f5 - f3);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(baseFont, f);
        pdfAppearance2.resetRGBColorFill();
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        pdfAppearance.drawTextField(0.0f, 0.0f, f4 - f2, f5 - f3);
        pdfAppearance.beginVariableText();
        pdfAppearance.saveState();
        pdfAppearance.rectangle(3.0f, 3.0f, f4 - f2 - 6.0f, f5 - f3 - 6.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f);
        pdfAppearance.resetRGBColorFill();
        pdfAppearance.setTextMatrix(4.0f, 5.0f);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        float f6 = f5 - f3;
        while (stringTokenizer.hasMoreTokens()) {
            pdfAppearance.showTextAligned(0, stringTokenizer.nextToken(), 3.0f, f6 -= f * 1.2f, 0.0f);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }

    private void setCheckBoxParams(PdfFormField pdfFormField, String string, String string2, boolean bl, float f, float f2, float f3, float f4) {
        pdfFormField.setWidget(new Rectangle(f, f2, f3, f4), PdfAnnotation.HIGHLIGHT_TOGGLE);
        pdfFormField.setFieldName(string);
        if (bl) {
            pdfFormField.setValueAsName(string2);
            pdfFormField.setAppearanceState(string2);
        } else {
            pdfFormField.setValueAsName("Off");
            pdfFormField.setAppearanceState("Off");
        }
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setBorderStyle(new PdfBorderDictionary(1.0f, 0));
    }

    private void drawCheckBoxAppearences(PdfFormField pdfFormField, String string, float f, float f2, float f3, float f4) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont("ZapfDingbats", "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        float f5 = f4 - f2;
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.writer, f3 - f, f4 - f2);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(baseFont, f5);
        pdfAppearance2.resetRGBColorFill();
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        pdfAppearance.drawTextField(0.0f, 0.0f, f3 - f, f4 - f2);
        pdfAppearance.saveState();
        pdfAppearance.resetRGBColorFill();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f5);
        pdfAppearance.showTextAligned(1, "4", (f3 - f) / 2.0f, (f4 - f2) / 2.0f - f5 * 0.3f, 0.0f);
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, string, pdfAppearance);
        PdfAppearance pdfAppearance3 = PdfAppearance.createAppearance(this.writer, f3 - f, f4 - f2);
        pdfAppearance3.drawTextField(0.0f, 0.0f, f3 - f, f4 - f2);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", pdfAppearance3);
    }

    private void drawRadioAppearences(PdfFormField pdfFormField, String string, float f, float f2, float f3, float f4) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.writer, f3 - f, f4 - f2);
        pdfAppearance.drawRadioField(0.0f, 0.0f, f3 - f, f4 - f2, true);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, string, pdfAppearance);
        PdfAppearance pdfAppearance2 = PdfAppearance.createAppearance(this.writer, f3 - f, f4 - f2);
        pdfAppearance2.drawRadioField(0.0f, 0.0f, f3 - f, f4 - f2, false);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", pdfAppearance2);
    }

    private void setChoiceParams(PdfFormField pdfFormField, String string, String string2, float f, float f2, float f3, float f4) {
        pdfFormField.setWidget(new Rectangle(f, f2, f3, f4), PdfAnnotation.HIGHLIGHT_INVERT);
        if (string2 != null) {
            pdfFormField.setValueAsString(string2);
            pdfFormField.setDefaultValueAsString(string2);
        }
        pdfFormField.setFieldName(string);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setBorderStyle(new PdfBorderDictionary(2.0f, 0));
    }
}

