/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfResources;
import java.util.HashMap;
import java.util.LinkedHashMap;

class PageResources {
    private final PdfDictionary fontDictionary = new PdfDictionary();
    private final PdfDictionary xObjectDictionary = new PdfDictionary();
    private final PdfDictionary colorDictionary = new PdfDictionary();
    private final PdfDictionary patternDictionary = new PdfDictionary();
    private final PdfDictionary shadingDictionary = new PdfDictionary();
    private final PdfDictionary extGStateDictionary = new PdfDictionary();
    private final PdfDictionary propertyDictionary = new PdfDictionary();
    private HashMap forbiddenNames;
    private PdfDictionary originalResources;
    private int[] namePtr = new int[]{0};
    private HashMap usedNames;

    PageResources() {
    }

    void setOriginalResources(PdfDictionary pdfDictionary, int[] nArray) {
        if (nArray != null) {
            this.namePtr = nArray;
        }
        this.forbiddenNames = new LinkedHashMap();
        this.usedNames = new LinkedHashMap();
        if (pdfDictionary == null) {
            return;
        }
        this.originalResources = new PdfDictionary();
        this.originalResources.merge(pdfDictionary);
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            PdfName pdfName2 = pdfName;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName2));
            if (pdfObject == null || !pdfObject.isDictionary()) continue;
            PdfDictionary pdfDictionary2 = (PdfDictionary)pdfObject;
            for (PdfName pdfName3 : pdfDictionary2.getKeys()) {
                this.forbiddenNames.put(pdfName3, null);
            }
            PdfDictionary pdfDictionary3 = new PdfDictionary();
            pdfDictionary3.merge(pdfDictionary2);
            this.originalResources.put(pdfName2, pdfDictionary3);
        }
    }

    private PdfName translateName(PdfName pdfName) {
        PdfName pdfName2 = pdfName;
        if (this.forbiddenNames != null && (pdfName2 = (PdfName)this.usedNames.get(pdfName)) == null) {
            int n;
            do {
                n = this.namePtr[0];
                this.namePtr[0] = n + 1;
            } while (this.forbiddenNames.containsKey(pdfName2 = new PdfName("Xi" + n)));
            this.usedNames.put(pdfName, pdfName2);
        }
        return pdfName2;
    }

    PdfName addFont(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.fontDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addXObject(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.xObjectDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addColor(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.colorDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    void addDefaultColor(PdfDictionary pdfDictionary) {
        this.colorDictionary.merge(pdfDictionary);
    }

    void addDefaultColorDiff(PdfDictionary pdfDictionary) {
        this.colorDictionary.mergeDifferent(pdfDictionary);
    }

    PdfName addShading(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.shadingDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addPattern(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.patternDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addExtGState(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.extGStateDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addProperty(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.propertyDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfDictionary getResources() {
        PdfResources pdfResources = new PdfResources();
        if (this.originalResources != null) {
            pdfResources.putAll(this.originalResources);
        }
        pdfResources.put(PdfName.PROCSET, new PdfLiteral("[/PDF /Text /ImageB /ImageC /ImageI]"));
        pdfResources.add(PdfName.FONT, this.fontDictionary);
        pdfResources.add(PdfName.XOBJECT, this.xObjectDictionary);
        pdfResources.add(PdfName.COLORSPACE, this.colorDictionary);
        pdfResources.add(PdfName.PATTERN, this.patternDictionary);
        pdfResources.add(PdfName.SHADING, this.shadingDictionary);
        pdfResources.add(PdfName.EXTGSTATE, this.extGStateDictionary);
        pdfResources.add(PdfName.PROPERTIES, this.propertyDictionary);
        return pdfResources;
    }

    boolean hasResources() {
        return this.fontDictionary.size() > 0 || this.xObjectDictionary.size() > 0 || this.colorDictionary.size() > 0 || this.patternDictionary.size() > 0 || this.shadingDictionary.size() > 0 || this.extGStateDictionary.size() > 0 || this.propertyDictionary.size() > 0;
    }
}

