/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PRStream
extends PdfStream {
    private PdfReader reader;
    private int offset;
    private int length;
    private int objNum = 0;
    private int objGen = 0;

    PRStream(PRStream pRStream, PdfDictionary pdfDictionary) {
        this.reader = pRStream.reader;
        this.offset = pRStream.offset;
        this.length = pRStream.length;
        this.compressed = pRStream.compressed;
        this.compressionLevel = pRStream.compressionLevel;
        this.streamBytes = pRStream.streamBytes;
        this.bytes = pRStream.bytes;
        this.objNum = pRStream.objNum;
        this.objGen = pRStream.objGen;
        if (pdfDictionary != null) {
            this.putAll(pdfDictionary);
        } else {
            this.hashMap.putAll(pRStream.hashMap);
        }
    }

    PRStream(PRStream pRStream, PdfDictionary pdfDictionary, PdfReader pdfReader) {
        this(pRStream, pdfDictionary);
        this.reader = pdfReader;
    }

    PRStream(PdfReader pdfReader, int n) {
        this.reader = pdfReader;
        this.offset = n;
    }

    PRStream(PdfReader pdfReader, byte[] byArray, int n) {
        this.reader = pdfReader;
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(n);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                deflater.end();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    private void setData(byte[] byArray, boolean bl) {
        this.setData(byArray, bl, -1);
    }

    private void setData(byte[] byArray, boolean bl, int n) {
        this.remove(PdfName.FILTER);
        this.offset = -1;
        if (Document.compress && bl) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(n);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                deflater.end();
                this.bytes = byteArrayOutputStream.toByteArray();
                this.compressionLevel = n;
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, true);
    }

    public void setLength(int n) {
        this.length = n;
        this.put(PdfName.LENGTH, new PdfNumber(n));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    void setObjNum(int n, int n2) {
        this.objNum = n;
        this.objGen = n2;
    }

    int getObjNum() {
        return this.objNum;
    }

    int getObjGen() {
        return this.objGen;
    }

    @Override
    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        byte[] byArray = PdfReader.getStreamBytesRaw(this);
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.getEncryption();
        }
        PdfObject pdfObject = this.get(PdfName.LENGTH);
        int n = byArray.length;
        if (pdfEncryption != null) {
            n = pdfEncryption.calculateStreamSize(n);
        }
        this.put(PdfName.LENGTH, new PdfNumber(n));
        this.superToPdf(pdfWriter, outputStream);
        this.put(PdfName.LENGTH, pdfObject);
        outputStream.write(STARTSTREAM);
        if (this.length > 0) {
            if (pdfEncryption != null && !pdfEncryption.isEmbeddedFilesOnly()) {
                byArray = pdfEncryption.encryptByteArray(byArray);
            }
            outputStream.write(byArray);
        }
        outputStream.write(ENDSTREAM);
    }
}

