/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;

class PRAcroForm
extends PdfDictionary {
    private final ArrayList fields;
    private final ArrayList stack;
    private final HashMap fieldByName;
    private final PdfReader reader;

    PRAcroForm(PdfReader pdfReader) {
        this.reader = pdfReader;
        this.fields = new ArrayList();
        this.fieldByName = new LinkedHashMap();
        this.stack = new ArrayList();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    public ArrayList getFields() {
        return this.fields;
    }

    void readAcroForm(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return;
        }
        this.hashMap = pdfDictionary.hashMap;
        this.pushAttrib(pdfDictionary);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FIELDS));
        this.iterateFields(pdfArray, null, null);
    }

    private void iterateFields(PdfArray pdfArray, PRIndirectReference pRIndirectReference, String string) {
        ListIterator<PdfObject> listIterator = pdfArray.listIterator();
        while (listIterator.hasNext()) {
            PdfArray pdfArray2;
            boolean bl;
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)listIterator.next();
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference2);
            PRIndirectReference pRIndirectReference3 = pRIndirectReference;
            String string2 = string;
            PdfString pdfString = (PdfString)pdfDictionary.get(PdfName.T);
            boolean bl2 = bl = pdfString != null;
            if (bl) {
                pRIndirectReference3 = pRIndirectReference2;
                string2 = string == null ? pdfString.toString() : string + '.' + pdfString.toString();
            }
            if ((pdfArray2 = (PdfArray)pdfDictionary.get(PdfName.KIDS)) != null) {
                this.pushAttrib(pdfDictionary);
                this.iterateFields(pdfArray2, pRIndirectReference3, string2);
                this.stack.remove(this.stack.size() - 1);
                continue;
            }
            if (pRIndirectReference3 == null) continue;
            PdfDictionary pdfDictionary2 = (PdfDictionary)this.stack.get(this.stack.size() - 1);
            if (bl) {
                pdfDictionary2 = this.mergeAttrib(pdfDictionary2, pdfDictionary);
            }
            pdfDictionary2.put(PdfName.T, new PdfString(string2));
            FieldInformation fieldInformation = new FieldInformation(string2, pdfDictionary2, pRIndirectReference3);
            this.fields.add(fieldInformation);
            this.fieldByName.put(string2, fieldInformation);
        }
    }

    private PdfDictionary mergeAttrib(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        if (pdfDictionary != null) {
            pdfDictionary3.putAll(pdfDictionary);
        }
        for (PdfName pdfName : pdfDictionary2.getKeys()) {
            PdfName pdfName2 = pdfName;
            if (!pdfName2.equals(PdfName.DR) && !pdfName2.equals(PdfName.DA) && !pdfName2.equals(PdfName.Q) && !pdfName2.equals(PdfName.FF) && !pdfName2.equals(PdfName.DV) && !pdfName2.equals(PdfName.V) && !pdfName2.equals(PdfName.FT) && !pdfName2.equals(PdfName.F)) continue;
            pdfDictionary3.put(pdfName2, pdfDictionary2.get(pdfName2));
        }
        return pdfDictionary3;
    }

    private void pushAttrib(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = null;
        if (!this.stack.isEmpty()) {
            pdfDictionary2 = (PdfDictionary)this.stack.get(this.stack.size() - 1);
        }
        pdfDictionary2 = this.mergeAttrib(pdfDictionary2, pdfDictionary);
        this.stack.add(pdfDictionary2);
    }

    private static class FieldInformation {
        private final String name;
        private final PdfDictionary info;
        private final PRIndirectReference ref;

        private FieldInformation(String string, PdfDictionary pdfDictionary, PRIndirectReference pRIndirectReference) {
            this.name = string;
            this.info = pdfDictionary;
            this.ref = pRIndirectReference;
        }

        public String getName() {
            return this.name;
        }

        public PdfDictionary getInfo() {
            return this.info;
        }

        public PRIndirectReference getRef() {
            return this.ref;
        }
    }
}

