/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfDocument;
import java.util.ArrayList;

class MultiColumnText
implements Element {
    private static final float AUTOMATIC = -1.0f;
    private final float desiredHeight;
    private float totalHeight;
    private boolean overflow;
    private float top;
    private final ColumnText columnText;
    private final ArrayList columnDefs = new ArrayList();
    private final boolean simple = true;
    private int currentColumn = 0;
    private float nextY = -1.0f;
    private boolean columnsRightToLeft = false;
    private PdfDocument document;

    public MultiColumnText() {
        this(-1.0f);
    }

    private MultiColumnText(float f) {
        this.desiredHeight = f;
        this.top = -1.0f;
        this.columnText = new ColumnText(null);
        this.totalHeight = 0.0f;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    private void addSimpleColumn(float f, float f2) {
        ColumnDef columnDef = new ColumnDef(f, f2);
        this.columnDefs.add(columnDef);
    }

    private void newPage() throws DocumentException {
        this.resetCurrentColumn();
        if (this.desiredHeight == -1.0f) {
            this.nextY = -1.0f;
            this.top = -1.0f;
        } else {
            this.top = this.nextY;
        }
        this.totalHeight = 0.0f;
        if (this.document != null) {
            this.document.newPage();
        }
    }

    private float getHeight(float[] fArray, float[] fArray2) {
        int n;
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        for (n = 0; n < fArray.length; n += 2) {
            f2 = Math.min(f2, fArray[n + 1]);
            f = Math.max(f, fArray[n + 1]);
        }
        for (n = 0; n < fArray2.length; n += 2) {
            f2 = Math.min(f2, fArray2[n + 1]);
            f = Math.max(f, fArray2[n + 1]);
        }
        return f - f2;
    }

    @Override
    public int type() {
        return 40;
    }

    @Override
    public ArrayList getChunks() {
        return null;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    private float getColumnBottom() {
        if (this.desiredHeight == -1.0f) {
            return this.document.bottom();
        }
        return Math.max(this.top - (this.desiredHeight - this.totalHeight), this.document.bottom());
    }

    public int getCurrentColumn() {
        if (this.columnsRightToLeft) {
            return this.columnDefs.size() - this.currentColumn - 1;
        }
        return this.currentColumn;
    }

    private void resetCurrentColumn() {
        this.currentColumn = 0;
    }

    private boolean shiftCurrentColumn() {
        if (this.currentColumn + 1 < this.columnDefs.size()) {
            ++this.currentColumn;
            return true;
        }
        return false;
    }

    public void setColumnsRightToLeft(boolean bl) {
        this.columnsRightToLeft = bl;
    }

    public void setSpaceCharRatio(float f) {
        this.columnText.setSpaceCharRatio(f);
    }

    public void setRunDirection(int n) {
        this.columnText.setRunDirection(n);
    }

    public void setArabicOptions(int n) {
        this.columnText.setArabicOptions(n);
    }

    public void setAlignment(int n) {
        this.columnText.setAlignment(n);
    }

    private class ColumnDef {
        private final float[] left;
        private final float[] right;

        ColumnDef(float[] fArray, float[] fArray2) {
            this.left = fArray;
            this.right = fArray2;
        }

        ColumnDef(float f, float f2) {
            this.left = new float[4];
            this.left[0] = f;
            this.left[1] = MultiColumnText.this.top;
            this.left[2] = f;
            this.left[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
            this.right = new float[4];
            this.right[0] = f2;
            this.right[1] = MultiColumnText.this.top;
            this.right[2] = f2;
            this.right[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
        }

        float[] resolvePositions(int n) {
            if (n == 4) {
                return this.resolvePositions(this.left);
            }
            return this.resolvePositions(this.right);
        }

        private float[] resolvePositions(float[] fArray) {
            if (!this.isSimple()) {
                fArray[1] = MultiColumnText.this.top;
                return fArray;
            }
            if (MultiColumnText.this.top == -1.0f) {
                throw new RuntimeException("resolvePositions called with top=AUTOMATIC (-1).  Top position must be set befure lines can be resolved");
            }
            fArray[1] = MultiColumnText.this.top;
            fArray[3] = MultiColumnText.this.getColumnBottom();
            return fArray;
        }

        private boolean isSimple() {
            return this.left.length == 4 && this.right.length == 4 && this.left[0] == this.left[2] && this.right[0] == this.right[2];
        }
    }
}

