/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import java.io.IOException;
import java.io.OutputStream;

class LZWDecoder {
    private byte[][] stringTable;
    private byte[] data = null;
    private OutputStream uncompData;
    private int tableIndex;
    private int bitsToGet = 9;
    private int bytePointer;
    private int bitPointer;
    private int nextData = 0;
    private int nextBits = 0;
    private final int[] andTable = new int[]{511, 1023, 2047, 4095};

    public void decode(byte[] byArray, OutputStream outputStream) {
        int n;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new RuntimeException("LZW flavour not supported.");
        }
        this.initializeStringTable();
        this.data = byArray;
        this.uncompData = outputStream;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int n2 = 0;
        while ((n = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n == 256) {
                this.initializeStringTable();
                n = this.getNextCode();
                if (n == 257) break;
                this.writeString(this.stringTable[n]);
                n2 = n;
                continue;
            }
            if (n < this.tableIndex) {
                byArray2 = this.stringTable[n];
                this.writeString(byArray2);
                this.addStringToTable(this.stringTable[n2], byArray2[0]);
                n2 = n;
                continue;
            }
            byArray2 = this.stringTable[n2];
            byArray2 = this.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n2 = n;
        }
    }

    private void initializeStringTable() {
        this.stringTable = new byte[8192][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    private void writeString(byte[] byArray) {
        try {
            this.uncompData.write(byArray);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private void addStringToTable(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    private void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    private byte[] composeString(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int n = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

