/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;

class MarkedSection
extends MarkedObject {
    private MarkedObject title = null;

    MarkedSection() {
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            for (Element element : (Section)this.element) {
                elementListener.add(element);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public void setTitle(MarkedObject markedObject) {
        if (markedObject.element instanceof Paragraph) {
            this.title = markedObject;
        }
    }

    public MarkedObject getTitle() {
        Paragraph paragraph = Section.constructTitle((Paragraph)this.title.element, ((Section)this.element).numbers, ((Section)this.element).numberDepth, ((Section)this.element).numberStyle);
        MarkedObject markedObject = new MarkedObject(paragraph);
        markedObject.markupAttributes = this.title.markupAttributes;
        return markedObject;
    }

    public void setNumberDepth(int n) {
        ((Section)this.element).setNumberDepth(n);
    }

    public void setIndentationLeft(float f) {
        ((Section)this.element).setIndentationLeft(f);
    }

    public void setIndentationRight(float f) {
        ((Section)this.element).setIndentationRight(f);
    }

    public void setIndentation(float f) {
        ((Section)this.element).setIndentation(f);
    }

    public void setBookmarkOpen(boolean bl) {
        ((Section)this.element).setBookmarkOpen(bl);
    }

    public void setTriggerNewPage(boolean bl) {
        ((Section)this.element).setTriggerNewPage(bl);
    }

    public void setBookmarkTitle(String string) {
        ((Section)this.element).setBookmarkTitle(string);
    }
}

