/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Jpeg
extends Image {
    private static final int NOT_A_MARKER = -1;
    private static final int VALID_MARKER = 0;
    private static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    private static final int UNSUPPORTED_MARKER = 1;
    private static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    private static final int NOPARAM_MARKER = 2;
    private static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    private static final int M_APP0 = 224;
    private static final int M_APP2 = 226;
    private static final int M_APPE = 238;
    private static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};
    private byte[][] icc;

    Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        for (int n2 : VALID_MARKERS) {
            if (n != n2) continue;
            return 0;
        }
        for (int n2 : NOPARAM_MARKERS) {
            if (n != n2) continue;
            return 2;
        }
        for (int n2 : UNSUPPORTED_MARKERS) {
            if (n != n2) continue;
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws BadElementException, IOException {
        int n;
        this.type = 32;
        this.originalType = 1;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            if (inputStream.read() != 255 || inputStream.read() != 216) {
                throw new BadElementException(string + " is not a valid JPEG-file.");
            }
            n = 1;
            while (true) {
                int n2;
                int n3;
                int n4;
                int n5;
                if ((n5 = inputStream.read()) < 0) {
                    throw new IOException("Premature EOF while reading JPG.");
                }
                if (n5 != 255) continue;
                int n6 = inputStream.read();
                if (n != 0 && n6 == 224) {
                    n = 0;
                    n4 = Jpeg.getShort(inputStream);
                    if (n4 < 16) {
                        Utilities.skip(inputStream, n4 - 2);
                        continue;
                    }
                    byte[] byArray = new byte[JFIF_ID.length];
                    int i = inputStream.read(byArray);
                    if (i != byArray.length) {
                        throw new BadElementException(string + " corrupted JFIF marker.");
                    }
                    n3 = 1;
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        if (byArray[n2] == JFIF_ID[n2]) continue;
                        n3 = 0;
                        break;
                    }
                    if (n3 == 0) {
                        Utilities.skip(inputStream, n4 - 2 - byArray.length);
                        continue;
                    }
                    Utilities.skip(inputStream, 2);
                    n2 = inputStream.read();
                    int n7 = Jpeg.getShort(inputStream);
                    int n8 = Jpeg.getShort(inputStream);
                    if (n2 == 1) {
                        this.dpiX = n7;
                        this.dpiY = n8;
                    } else if (n2 == 2) {
                        this.dpiX = (int)((float)n7 * 2.54f + 0.5f);
                        this.dpiY = (int)((float)n8 * 2.54f + 0.5f);
                    }
                    Utilities.skip(inputStream, n4 - 2 - byArray.length - 7);
                    continue;
                }
                if (n6 == 238) {
                    String i;
                    n4 = Jpeg.getShort(inputStream) - 2;
                    byte[] byArray = new byte[n4];
                    for (int string2 = 0; string2 < n4; ++string2) {
                        byArray[string2] = (byte)inputStream.read();
                    }
                    if (byArray.length < 12 || !(i = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                    this.invert = true;
                    continue;
                }
                if (n6 == 226) {
                    String string2;
                    n4 = Jpeg.getShort(inputStream) - 2;
                    byte[] n10 = new byte[n4];
                    for (int string3 = 0; string3 < n4; ++string3) {
                        n10[string3] = (byte)inputStream.read();
                    }
                    if (n10.length < 14 || !(string2 = new String(n10, 0, 11, "ISO-8859-1")).equals("ICC_PROFILE")) continue;
                    n3 = n10[12] & 0xFF;
                    n2 = n10[13] & 0xFF;
                    if (this.icc == null) {
                        this.icc = new byte[n2][];
                    }
                    this.icc[n3 - 1] = n10;
                    continue;
                }
                n = 0;
                int byArray2 = Jpeg.marker(n6);
                if (byArray2 == 0) {
                    Utilities.skip(inputStream, 2);
                    if (inputStream.read() != 8) {
                        throw new BadElementException(string + " must have 8 bits per component.");
                    }
                    this.scaledHeight = Jpeg.getShort(inputStream);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(inputStream);
                    this.setRight(this.scaledWidth);
                    this.colorspace = inputStream.read();
                    this.bpc = 8;
                    break;
                }
                if (byArray2 == 1) {
                    throw new BadElementException(string + ": unsupported JPEG marker: " + n6);
                }
                if (byArray2 == 2) continue;
                Utilities.skip(inputStream, Jpeg.getShort(inputStream) - 2);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
        if (this.icc != null) {
            int n11 = 0;
            for (n = 0; n < this.icc.length; ++n) {
                if (this.icc[n] == null) {
                    this.icc = null;
                    return;
                }
                n11 += this.icc[n].length - 14;
            }
            byte[] byArray = new byte[n11];
            n11 = 0;
            for (byte[] byArray2 : this.icc) {
                System.arraycopy(byArray2, 14, byArray, n11, byArray2.length - 14);
                n11 += byArray2.length - 14;
            }
            try {
                ICC_Profile illegalArgumentException = ICC_Profile.getInstance(byArray);
                this.tagICC(illegalArgumentException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.icc = null;
        }
    }
}

