/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.OutputStreamCounter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DocWriter
implements DocListener {
    private static final byte SPACE = 32;
    private static final byte EQUALS = 61;
    private static final byte QUOTE = 34;
    private static final byte GT = 62;
    private static final byte FORWARD = 47;
    protected OutputStreamCounter os;
    protected boolean open = false;
    private final boolean pause = false;
    private boolean closeStream = true;

    protected DocWriter() {
    }

    protected DocWriter(Document document, OutputStream outputStream) {
        this.os = new OutputStreamCounter(new BufferedOutputStream(outputStream));
    }

    @Override
    public boolean add(Element element) throws DocumentException {
        return false;
    }

    @Override
    public void open() {
        this.open = true;
    }

    @Override
    public boolean setPageSize(Rectangle rectangle) {
        return true;
    }

    @Override
    public boolean setMargins(float f, float f2, float f3, float f4) {
        return false;
    }

    @Override
    public boolean newPage() {
        return this.open;
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
    }

    @Override
    public void resetHeader() {
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
    }

    @Override
    public void resetFooter() {
    }

    @Override
    public void resetPageCount() {
    }

    @Override
    public void setPageCount(int n) {
    }

    @Override
    public void close() {
        this.open = false;
        try {
            this.os.flush();
            if (this.closeStream) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static final byte[] getISOBytes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public boolean isPaused() {
        return this.pause;
    }

    private void write(String string) throws IOException {
        this.os.write(DocWriter.getISOBytes(string));
    }

    private void write(String string, String string2) throws IOException {
        this.os.write(32);
        this.write(string);
        this.os.write(61);
        this.os.write(34);
        this.write(string2);
        this.os.write(34);
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean bl) {
        this.closeStream = bl;
    }

    @Override
    public boolean setMarginMirroring(boolean bl) {
        return false;
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean bl) {
        return false;
    }
}

