/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Element;
import java.util.ArrayList;
import java.util.HashMap;

public class Annotation
implements Element {
    private static final int TEXT = 0;
    public static final int URL_NET = 1;
    public static final int URL_AS_STRING = 2;
    public static final int FILE_DEST = 3;
    public static final int FILE_PAGE = 4;
    public static final int NAMED_DEST = 5;
    public static final int LAUNCH = 6;
    public static final int SCREEN = 7;
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    public static final String URL = "url";
    public static final String FILE = "file";
    public static final String DESTINATION = "destination";
    public static final String PAGE = "page";
    public static final String NAMED = "named";
    public static final String APPLICATION = "application";
    public static final String PARAMETERS = "parameters";
    public static final String OPERATION = "operation";
    public static final String DEFAULTDIR = "defaultdir";
    public static final String MIMETYPE = "mime";
    private int annotationtype;
    private HashMap annotationAttributes = new HashMap();
    private float llx = Float.NaN;
    private float lly = Float.NaN;
    private float urx = Float.NaN;
    private float ury = Float.NaN;

    private Annotation(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public Annotation(Annotation annotation) {
        this.annotationtype = annotation.annotationtype;
        this.annotationAttributes = annotation.annotationAttributes;
        this.llx = annotation.llx;
        this.lly = annotation.lly;
        this.urx = annotation.urx;
        this.ury = annotation.ury;
    }

    public Annotation(String string, String string2, float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4);
        this.annotationtype = 0;
        this.annotationAttributes.put(TITLE, string);
        this.annotationAttributes.put(CONTENT, string2);
    }

    public Annotation(float f, float f2, float f3, float f4, String string) {
        this(f, f2, f3, f4);
        this.annotationtype = 2;
        this.annotationAttributes.put(FILE, string);
    }

    public Annotation(float f, float f2, float f3, float f4, String string, String string2) {
        this(f, f2, f3, f4);
        this.annotationtype = 3;
        this.annotationAttributes.put(FILE, string);
        this.annotationAttributes.put(DESTINATION, string2);
    }

    public Annotation(float f, float f2, float f3, float f4, String string, int n) {
        this(f, f2, f3, f4);
        this.annotationtype = 4;
        this.annotationAttributes.put(FILE, string);
        this.annotationAttributes.put(PAGE, new Integer(n));
    }

    public Annotation(float f, float f2, float f3, float f4, int n) {
        this(f, f2, f3, f4);
        this.annotationtype = 5;
        this.annotationAttributes.put(NAMED, new Integer(n));
    }

    @Override
    public int type() {
        return 29;
    }

    @Override
    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void setDimensions(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public float llx() {
        return this.llx;
    }

    public float lly() {
        return this.lly;
    }

    public float urx() {
        return this.urx;
    }

    public float ury() {
        return this.ury;
    }

    public int annotationType() {
        return this.annotationtype;
    }

    public String title() {
        String string = (String)this.annotationAttributes.get(TITLE);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String content() {
        String string = (String)this.annotationAttributes.get(CONTENT);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public HashMap attributes() {
        return this.annotationAttributes;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }
}

