/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Phrase;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class Anchor
extends Phrase {
    private static final long serialVersionUID = -852278536049236911L;
    private String name = null;
    private String reference = null;

    public Anchor() {
        super(16.0f);
    }

    public Anchor(Phrase phrase) {
        super(phrase);
        if (phrase instanceof Anchor) {
            Anchor anchor = (Anchor)phrase;
            this.setName(anchor.name);
            this.setReference(anchor.reference);
        }
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.getChunks().iterator();
            boolean bl = this.reference != null && this.reference.startsWith("#");
            boolean bl2 = true;
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                if (this.name != null && bl2 && !chunk.isEmpty()) {
                    chunk.setLocalDestination(this.name);
                    bl2 = false;
                }
                if (bl) {
                    chunk.setLocalGoto(this.reference.substring(1));
                }
                elementListener.add(chunk);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        Iterator iterator = this.iterator();
        boolean bl = this.reference != null && this.reference.startsWith("#");
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            if (this.name != null && bl2 && !chunk.isEmpty()) {
                chunk.setLocalDestination(this.name);
                bl2 = false;
            }
            if (bl) {
                chunk.setLocalGoto(this.reference.substring(1));
            } else if (this.reference != null) {
                chunk.setAnchor(this.reference);
            }
            arrayList.add(chunk);
        }
        return arrayList;
    }

    @Override
    public int type() {
        return 17;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public URL getUrl() {
        try {
            return new URL(this.reference);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

